/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RdsDbInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RdsDbInstance> {
    private static final SdkField<String> RDS_DB_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RdsDbInstanceArn").getter(RdsDbInstance.getter(RdsDbInstance::rdsDbInstanceArn)).setter(RdsDbInstance.setter(Builder::rdsDbInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsDbInstanceArn").build()}).build();
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbInstanceIdentifier").getter(RdsDbInstance.getter(RdsDbInstance::dbInstanceIdentifier)).setter(RdsDbInstance.setter(Builder::dbInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbInstanceIdentifier").build()}).build();
    private static final SdkField<String> DB_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbUser").getter(RdsDbInstance.getter(RdsDbInstance::dbUser)).setter(RdsDbInstance.setter(Builder::dbUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()}).build();
    private static final SdkField<String> DB_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbPassword").getter(RdsDbInstance.getter(RdsDbInstance::dbPassword)).setter(RdsDbInstance.setter(Builder::dbPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbPassword").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(RdsDbInstance.getter(RdsDbInstance::region)).setter(RdsDbInstance.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Address").getter(RdsDbInstance.getter(RdsDbInstance::address)).setter(RdsDbInstance.setter(Builder::address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(RdsDbInstance.getter(RdsDbInstance::engine)).setter(RdsDbInstance.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(RdsDbInstance.getter(RdsDbInstance::stackId)).setter(RdsDbInstance.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<Boolean> MISSING_ON_RDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MissingOnRds").getter(RdsDbInstance.getter(RdsDbInstance::missingOnRds)).setter(RdsDbInstance.setter(Builder::missingOnRds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingOnRds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RDS_DB_INSTANCE_ARN_FIELD, DB_INSTANCE_IDENTIFIER_FIELD, DB_USER_FIELD, DB_PASSWORD_FIELD, REGION_FIELD, ADDRESS_FIELD, ENGINE_FIELD, STACK_ID_FIELD, MISSING_ON_RDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RdsDbInstanceArn", RDS_DB_INSTANCE_ARN_FIELD);
            this.put("DbInstanceIdentifier", DB_INSTANCE_IDENTIFIER_FIELD);
            this.put("DbUser", DB_USER_FIELD);
            this.put("DbPassword", DB_PASSWORD_FIELD);
            this.put("Region", REGION_FIELD);
            this.put("Address", ADDRESS_FIELD);
            this.put("Engine", ENGINE_FIELD);
            this.put("StackId", STACK_ID_FIELD);
            this.put("MissingOnRds", MISSING_ON_RDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String rdsDbInstanceArn;
    private final String dbInstanceIdentifier;
    private final String dbUser;
    private final String dbPassword;
    private final String region;
    private final String address;
    private final String engine;
    private final String stackId;
    private final Boolean missingOnRds;

    private RdsDbInstance(BuilderImpl builder) {
        this.rdsDbInstanceArn = builder.rdsDbInstanceArn;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.dbUser = builder.dbUser;
        this.dbPassword = builder.dbPassword;
        this.region = builder.region;
        this.address = builder.address;
        this.engine = builder.engine;
        this.stackId = builder.stackId;
        this.missingOnRds = builder.missingOnRds;
    }

    public final String rdsDbInstanceArn() {
        return this.rdsDbInstanceArn;
    }

    public final String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public final String dbUser() {
        return this.dbUser;
    }

    public final String dbPassword() {
        return this.dbPassword;
    }

    public final String region() {
        return this.region;
    }

    public final String address() {
        return this.address;
    }

    public final String engine() {
        return this.engine;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final Boolean missingOnRds() {
        return this.missingOnRds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsDbInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.missingOnRds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsDbInstance)) {
            return false;
        }
        RdsDbInstance other = (RdsDbInstance)obj;
        return Objects.equals(this.rdsDbInstanceArn(), other.rdsDbInstanceArn()) && Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.dbUser(), other.dbUser()) && Objects.equals(this.dbPassword(), other.dbPassword()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.address(), other.address()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.missingOnRds(), other.missingOnRds());
    }

    public final String toString() {
        return ToString.builder((String)"RdsDbInstance").add("RdsDbInstanceArn", (Object)this.rdsDbInstanceArn()).add("DbInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("DbUser", (Object)this.dbUser()).add("DbPassword", (Object)this.dbPassword()).add("Region", (Object)this.region()).add("Address", (Object)this.address()).add("Engine", (Object)this.engine()).add("StackId", (Object)this.stackId()).add("MissingOnRds", (Object)this.missingOnRds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RdsDbInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.rdsDbInstanceArn()));
            }
            case "DbInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "DbUser": {
                return Optional.ofNullable(clazz.cast(this.dbUser()));
            }
            case "DbPassword": {
                return Optional.ofNullable(clazz.cast(this.dbPassword()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "MissingOnRds": {
                return Optional.ofNullable(clazz.cast(this.missingOnRds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RdsDbInstance, T> g) {
        return obj -> g.apply((RdsDbInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String rdsDbInstanceArn;
        private String dbInstanceIdentifier;
        private String dbUser;
        private String dbPassword;
        private String region;
        private String address;
        private String engine;
        private String stackId;
        private Boolean missingOnRds;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsDbInstance model) {
            this.rdsDbInstanceArn(model.rdsDbInstanceArn);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.dbUser(model.dbUser);
            this.dbPassword(model.dbPassword);
            this.region(model.region);
            this.address(model.address);
            this.engine(model.engine);
            this.stackId(model.stackId);
            this.missingOnRds(model.missingOnRds);
        }

        public final String getRdsDbInstanceArn() {
            return this.rdsDbInstanceArn;
        }

        public final void setRdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
        }

        @Override
        public final Builder rdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
            return this;
        }

        public final String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final String getDbPassword() {
            return this.dbPassword;
        }

        public final void setDbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
        }

        @Override
        public final Builder dbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getAddress() {
            return this.address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getStackId() {
            return this.stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final Boolean getMissingOnRds() {
            return this.missingOnRds;
        }

        public final void setMissingOnRds(Boolean missingOnRds) {
            this.missingOnRds = missingOnRds;
        }

        @Override
        public final Builder missingOnRds(Boolean missingOnRds) {
            this.missingOnRds = missingOnRds;
            return this;
        }

        public RdsDbInstance build() {
            return new RdsDbInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RdsDbInstance> {
        public Builder rdsDbInstanceArn(String var1);

        public Builder dbInstanceIdentifier(String var1);

        public Builder dbUser(String var1);

        public Builder dbPassword(String var1);

        public Builder region(String var1);

        public Builder address(String var1);

        public Builder engine(String var1);

        public Builder stackId(String var1);

        public Builder missingOnRds(Boolean var1);
    }
}

