/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.ElasticLoadBalancer;
import software.amazon.awssdk.services.opsworks.model.ElasticLoadBalancersCopier;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeElasticLoadBalancersResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeElasticLoadBalancersResponse> {
    private static final SdkField<List<ElasticLoadBalancer>> ELASTIC_LOAD_BALANCERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ElasticLoadBalancers").getter(DescribeElasticLoadBalancersResponse.getter(DescribeElasticLoadBalancersResponse::elasticLoadBalancers)).setter(DescribeElasticLoadBalancersResponse.setter(Builder::elasticLoadBalancers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticLoadBalancers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ElasticLoadBalancer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELASTIC_LOAD_BALANCERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ElasticLoadBalancers", ELASTIC_LOAD_BALANCERS_FIELD);
        }
    });
    private final List<ElasticLoadBalancer> elasticLoadBalancers;

    private DescribeElasticLoadBalancersResponse(BuilderImpl builder) {
        super(builder);
        this.elasticLoadBalancers = builder.elasticLoadBalancers;
    }

    public final boolean hasElasticLoadBalancers() {
        return this.elasticLoadBalancers != null && !(this.elasticLoadBalancers instanceof SdkAutoConstructList);
    }

    public final List<ElasticLoadBalancer> elasticLoadBalancers() {
        return this.elasticLoadBalancers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasElasticLoadBalancers() ? this.elasticLoadBalancers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticLoadBalancersResponse)) {
            return false;
        }
        DescribeElasticLoadBalancersResponse other = (DescribeElasticLoadBalancersResponse)((Object)obj);
        return this.hasElasticLoadBalancers() == other.hasElasticLoadBalancers() && Objects.equals(this.elasticLoadBalancers(), other.elasticLoadBalancers());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeElasticLoadBalancersResponse").add("ElasticLoadBalancers", this.hasElasticLoadBalancers() ? this.elasticLoadBalancers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElasticLoadBalancers": {
                return Optional.ofNullable(clazz.cast(this.elasticLoadBalancers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeElasticLoadBalancersResponse, T> g) {
        return obj -> g.apply((DescribeElasticLoadBalancersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<ElasticLoadBalancer> elasticLoadBalancers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticLoadBalancersResponse model) {
            super(model);
            this.elasticLoadBalancers(model.elasticLoadBalancers);
        }

        public final List<ElasticLoadBalancer.Builder> getElasticLoadBalancers() {
            List<ElasticLoadBalancer.Builder> result = ElasticLoadBalancersCopier.copyToBuilder(this.elasticLoadBalancers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElasticLoadBalancers(Collection<ElasticLoadBalancer.BuilderImpl> elasticLoadBalancers) {
            this.elasticLoadBalancers = ElasticLoadBalancersCopier.copyFromBuilder(elasticLoadBalancers);
        }

        @Override
        public final Builder elasticLoadBalancers(Collection<ElasticLoadBalancer> elasticLoadBalancers) {
            this.elasticLoadBalancers = ElasticLoadBalancersCopier.copy(elasticLoadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticLoadBalancers(ElasticLoadBalancer ... elasticLoadBalancers) {
            this.elasticLoadBalancers(Arrays.asList(elasticLoadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticLoadBalancers(Consumer<ElasticLoadBalancer.Builder> ... elasticLoadBalancers) {
            this.elasticLoadBalancers(Stream.of(elasticLoadBalancers).map(c -> (ElasticLoadBalancer)((ElasticLoadBalancer.Builder)ElasticLoadBalancer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeElasticLoadBalancersResponse build() {
            return new DescribeElasticLoadBalancersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeElasticLoadBalancersResponse> {
        public Builder elasticLoadBalancers(Collection<ElasticLoadBalancer> var1);

        public Builder elasticLoadBalancers(ElasticLoadBalancer ... var1);

        public Builder elasticLoadBalancers(Consumer<ElasticLoadBalancer.Builder> ... var1);
    }
}

