/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.App;
import software.amazon.awssdk.services.opsworks.model.AppsCopier;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAppsResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeAppsResponse> {
    private static final SdkField<List<App>> APPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Apps").getter(DescribeAppsResponse.getter(DescribeAppsResponse::apps)).setter(DescribeAppsResponse.setter(Builder::apps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Apps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(App::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Apps", APPS_FIELD);
        }
    });
    private final List<App> apps;

    private DescribeAppsResponse(BuilderImpl builder) {
        super(builder);
        this.apps = builder.apps;
    }

    public final boolean hasApps() {
        return this.apps != null && !(this.apps instanceof SdkAutoConstructList);
    }

    public final List<App> apps() {
        return this.apps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApps() ? this.apps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppsResponse)) {
            return false;
        }
        DescribeAppsResponse other = (DescribeAppsResponse)((Object)obj);
        return this.hasApps() == other.hasApps() && Objects.equals(this.apps(), other.apps());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAppsResponse").add("Apps", this.hasApps() ? this.apps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Apps": {
                return Optional.ofNullable(clazz.cast(this.apps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppsResponse, T> g) {
        return obj -> g.apply((DescribeAppsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<App> apps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppsResponse model) {
            super(model);
            this.apps(model.apps);
        }

        public final List<App.Builder> getApps() {
            List<App.Builder> result = AppsCopier.copyToBuilder(this.apps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApps(Collection<App.BuilderImpl> apps) {
            this.apps = AppsCopier.copyFromBuilder(apps);
        }

        @Override
        public final Builder apps(Collection<App> apps) {
            this.apps = AppsCopier.copy(apps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apps(App ... apps) {
            this.apps(Arrays.asList(apps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apps(Consumer<App.Builder> ... apps) {
            this.apps(Stream.of(apps).map(c -> (App)((App.Builder)App.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAppsResponse build() {
            return new DescribeAppsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAppsResponse> {
        public Builder apps(Collection<App> var1);

        public Builder apps(App ... var1);

        public Builder apps(Consumer<App.Builder> ... var1);
    }
}

