/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserProfileRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, UpdateUserProfileRequest> {
    private static final SdkField<String> IAM_USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamUserArn").getter(UpdateUserProfileRequest.getter(UpdateUserProfileRequest::iamUserArn)).setter(UpdateUserProfileRequest.setter(Builder::iamUserArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamUserArn").build()}).build();
    private static final SdkField<String> SSH_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SshUsername").getter(UpdateUserProfileRequest.getter(UpdateUserProfileRequest::sshUsername)).setter(UpdateUserProfileRequest.setter(Builder::sshUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshUsername").build()}).build();
    private static final SdkField<String> SSH_PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SshPublicKey").getter(UpdateUserProfileRequest.getter(UpdateUserProfileRequest::sshPublicKey)).setter(UpdateUserProfileRequest.setter(Builder::sshPublicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKey").build()}).build();
    private static final SdkField<Boolean> ALLOW_SELF_MANAGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowSelfManagement").getter(UpdateUserProfileRequest.getter(UpdateUserProfileRequest::allowSelfManagement)).setter(UpdateUserProfileRequest.setter(Builder::allowSelfManagement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowSelfManagement").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_USER_ARN_FIELD, SSH_USERNAME_FIELD, SSH_PUBLIC_KEY_FIELD, ALLOW_SELF_MANAGEMENT_FIELD));
    private final String iamUserArn;
    private final String sshUsername;
    private final String sshPublicKey;
    private final Boolean allowSelfManagement;

    private UpdateUserProfileRequest(BuilderImpl builder) {
        super(builder);
        this.iamUserArn = builder.iamUserArn;
        this.sshUsername = builder.sshUsername;
        this.sshPublicKey = builder.sshPublicKey;
        this.allowSelfManagement = builder.allowSelfManagement;
    }

    public final String iamUserArn() {
        return this.iamUserArn;
    }

    public final String sshUsername() {
        return this.sshUsername;
    }

    public final String sshPublicKey() {
        return this.sshPublicKey;
    }

    public final Boolean allowSelfManagement() {
        return this.allowSelfManagement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowSelfManagement());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserProfileRequest)) {
            return false;
        }
        UpdateUserProfileRequest other = (UpdateUserProfileRequest)((Object)obj);
        return Objects.equals(this.iamUserArn(), other.iamUserArn()) && Objects.equals(this.sshUsername(), other.sshUsername()) && Objects.equals(this.sshPublicKey(), other.sshPublicKey()) && Objects.equals(this.allowSelfManagement(), other.allowSelfManagement());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateUserProfileRequest").add("IamUserArn", (Object)this.iamUserArn()).add("SshUsername", (Object)this.sshUsername()).add("SshPublicKey", (Object)this.sshPublicKey()).add("AllowSelfManagement", (Object)this.allowSelfManagement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IamUserArn": {
                return Optional.ofNullable(clazz.cast(this.iamUserArn()));
            }
            case "SshUsername": {
                return Optional.ofNullable(clazz.cast(this.sshUsername()));
            }
            case "SshPublicKey": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKey()));
            }
            case "AllowSelfManagement": {
                return Optional.ofNullable(clazz.cast(this.allowSelfManagement()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserProfileRequest, T> g) {
        return obj -> g.apply((UpdateUserProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String iamUserArn;
        private String sshUsername;
        private String sshPublicKey;
        private Boolean allowSelfManagement;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserProfileRequest model) {
            super(model);
            this.iamUserArn(model.iamUserArn);
            this.sshUsername(model.sshUsername);
            this.sshPublicKey(model.sshPublicKey);
            this.allowSelfManagement(model.allowSelfManagement);
        }

        public final String getIamUserArn() {
            return this.iamUserArn;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        @Override
        @Transient
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final String getSshUsername() {
            return this.sshUsername;
        }

        public final void setSshUsername(String sshUsername) {
            this.sshUsername = sshUsername;
        }

        @Override
        @Transient
        public final Builder sshUsername(String sshUsername) {
            this.sshUsername = sshUsername;
            return this;
        }

        public final String getSshPublicKey() {
            return this.sshPublicKey;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        @Override
        @Transient
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final Boolean getAllowSelfManagement() {
            return this.allowSelfManagement;
        }

        public final void setAllowSelfManagement(Boolean allowSelfManagement) {
            this.allowSelfManagement = allowSelfManagement;
        }

        @Override
        @Transient
        public final Builder allowSelfManagement(Boolean allowSelfManagement) {
            this.allowSelfManagement = allowSelfManagement;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserProfileRequest build() {
            return new UpdateUserProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUserProfileRequest> {
        public Builder iamUserArn(String var1);

        public Builder sshUsername(String var1);

        public Builder sshPublicKey(String var1);

        public Builder allowSelfManagement(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

