/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opsworks.model.StackConfigurationManager;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentVersion> {
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(AgentVersion.getter(AgentVersion::version)).setter(AgentVersion.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<StackConfigurationManager> CONFIGURATION_MANAGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConfigurationManager").getter(AgentVersion.getter(AgentVersion::configurationManager)).setter(AgentVersion.setter(Builder::configurationManager)).constructor(StackConfigurationManager::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationManager").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, CONFIGURATION_MANAGER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String version;
    private final StackConfigurationManager configurationManager;

    private AgentVersion(BuilderImpl builder) {
        this.version = builder.version;
        this.configurationManager = builder.configurationManager;
    }

    public final String version() {
        return this.version;
    }

    public final StackConfigurationManager configurationManager() {
        return this.configurationManager;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationManager());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentVersion)) {
            return false;
        }
        AgentVersion other = (AgentVersion)obj;
        return Objects.equals(this.version(), other.version()) && Objects.equals(this.configurationManager(), other.configurationManager());
    }

    public final String toString() {
        return ToString.builder((String)"AgentVersion").add("Version", (Object)this.version()).add("ConfigurationManager", (Object)this.configurationManager()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "ConfigurationManager": {
                return Optional.ofNullable(clazz.cast(this.configurationManager()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentVersion, T> g) {
        return obj -> g.apply((AgentVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private StackConfigurationManager configurationManager;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentVersion model) {
            this.version(model.version);
            this.configurationManager(model.configurationManager);
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final StackConfigurationManager.Builder getConfigurationManager() {
            return this.configurationManager != null ? this.configurationManager.toBuilder() : null;
        }

        public final void setConfigurationManager(StackConfigurationManager.BuilderImpl configurationManager) {
            this.configurationManager = configurationManager != null ? configurationManager.build() : null;
        }

        @Override
        @Transient
        public final Builder configurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        public AgentVersion build() {
            return new AgentVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentVersion> {
        public Builder version(String var1);

        public Builder configurationManager(StackConfigurationManager var1);

        default public Builder configurationManager(Consumer<StackConfigurationManager.Builder> configurationManager) {
            return this.configurationManager((StackConfigurationManager)((StackConfigurationManager.Builder)StackConfigurationManager.builder().applyMutation(configurationManager)).build());
        }
    }
}

