/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ShutdownEventConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ShutdownEventConfiguration> {
    private static final SdkField<Integer> EXECUTION_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExecutionTimeout").getter(ShutdownEventConfiguration.getter(ShutdownEventConfiguration::executionTimeout)).setter(ShutdownEventConfiguration.setter(Builder::executionTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTimeout").build()}).build();
    private static final SdkField<Boolean> DELAY_UNTIL_ELB_CONNECTIONS_DRAINED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DelayUntilElbConnectionsDrained").getter(ShutdownEventConfiguration.getter(ShutdownEventConfiguration::delayUntilElbConnectionsDrained)).setter(ShutdownEventConfiguration.setter(Builder::delayUntilElbConnectionsDrained)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelayUntilElbConnectionsDrained").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_TIMEOUT_FIELD, DELAY_UNTIL_ELB_CONNECTIONS_DRAINED_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer executionTimeout;
    private final Boolean delayUntilElbConnectionsDrained;

    private ShutdownEventConfiguration(BuilderImpl builder) {
        this.executionTimeout = builder.executionTimeout;
        this.delayUntilElbConnectionsDrained = builder.delayUntilElbConnectionsDrained;
    }

    public Integer executionTimeout() {
        return this.executionTimeout;
    }

    public Boolean delayUntilElbConnectionsDrained() {
        return this.delayUntilElbConnectionsDrained;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.delayUntilElbConnectionsDrained());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShutdownEventConfiguration)) {
            return false;
        }
        ShutdownEventConfiguration other = (ShutdownEventConfiguration)obj;
        return Objects.equals(this.executionTimeout(), other.executionTimeout()) && Objects.equals(this.delayUntilElbConnectionsDrained(), other.delayUntilElbConnectionsDrained());
    }

    public String toString() {
        return ToString.builder((String)"ShutdownEventConfiguration").add("ExecutionTimeout", (Object)this.executionTimeout()).add("DelayUntilElbConnectionsDrained", (Object)this.delayUntilElbConnectionsDrained()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionTimeout": {
                return Optional.ofNullable(clazz.cast(this.executionTimeout()));
            }
            case "DelayUntilElbConnectionsDrained": {
                return Optional.ofNullable(clazz.cast(this.delayUntilElbConnectionsDrained()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShutdownEventConfiguration, T> g) {
        return obj -> g.apply((ShutdownEventConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer executionTimeout;
        private Boolean delayUntilElbConnectionsDrained;

        private BuilderImpl() {
        }

        private BuilderImpl(ShutdownEventConfiguration model) {
            this.executionTimeout(model.executionTimeout);
            this.delayUntilElbConnectionsDrained(model.delayUntilElbConnectionsDrained);
        }

        public final Integer getExecutionTimeout() {
            return this.executionTimeout;
        }

        @Override
        public final Builder executionTimeout(Integer executionTimeout) {
            this.executionTimeout = executionTimeout;
            return this;
        }

        public final void setExecutionTimeout(Integer executionTimeout) {
            this.executionTimeout = executionTimeout;
        }

        public final Boolean getDelayUntilElbConnectionsDrained() {
            return this.delayUntilElbConnectionsDrained;
        }

        @Override
        public final Builder delayUntilElbConnectionsDrained(Boolean delayUntilElbConnectionsDrained) {
            this.delayUntilElbConnectionsDrained = delayUntilElbConnectionsDrained;
            return this;
        }

        public final void setDelayUntilElbConnectionsDrained(Boolean delayUntilElbConnectionsDrained) {
            this.delayUntilElbConnectionsDrained = delayUntilElbConnectionsDrained;
        }

        public ShutdownEventConfiguration build() {
            return new ShutdownEventConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ShutdownEventConfiguration> {
        public Builder executionTimeout(Integer var1);

        public Builder delayUntilElbConnectionsDrained(Boolean var1);
    }
}

