/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Architecture {
    X86_64("x86_64"),
    I386("i386"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Architecture(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Architecture fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Architecture.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Architecture> knownValues() {
        return Stream.of(Architecture.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

