/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Shutdown event configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShutdownEventConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ShutdownEventConfiguration.Builder, ShutdownEventConfiguration> {
    private static final SdkField<Integer> EXECUTION_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ShutdownEventConfiguration::executionTimeout)).setter(setter(Builder::executionTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTimeout").build()).build();

    private static final SdkField<Boolean> DELAY_UNTIL_ELB_CONNECTIONS_DRAINED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ShutdownEventConfiguration::delayUntilElbConnectionsDrained))
            .setter(setter(Builder::delayUntilElbConnectionsDrained))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelayUntilElbConnectionsDrained")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_TIMEOUT_FIELD,
            DELAY_UNTIL_ELB_CONNECTIONS_DRAINED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer executionTimeout;

    private final Boolean delayUntilElbConnectionsDrained;

    private ShutdownEventConfiguration(BuilderImpl builder) {
        this.executionTimeout = builder.executionTimeout;
        this.delayUntilElbConnectionsDrained = builder.delayUntilElbConnectionsDrained;
    }

    /**
     * <p>
     * The time, in seconds, that AWS OpsWorks Stacks will wait after triggering a Shutdown event before shutting down
     * an instance.
     * </p>
     * 
     * @return The time, in seconds, that AWS OpsWorks Stacks will wait after triggering a Shutdown event before
     *         shutting down an instance.
     */
    public Integer executionTimeout() {
        return executionTimeout;
    }

    /**
     * <p>
     * Whether to enable Elastic Load Balancing connection draining. For more information, see <a href=
     * "https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain"
     * >Connection Draining</a>
     * </p>
     * 
     * @return Whether to enable Elastic Load Balancing connection draining. For more information, see <a href=
     *         "https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain"
     *         >Connection Draining</a>
     */
    public Boolean delayUntilElbConnectionsDrained() {
        return delayUntilElbConnectionsDrained;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(delayUntilElbConnectionsDrained());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShutdownEventConfiguration)) {
            return false;
        }
        ShutdownEventConfiguration other = (ShutdownEventConfiguration) obj;
        return Objects.equals(executionTimeout(), other.executionTimeout())
                && Objects.equals(delayUntilElbConnectionsDrained(), other.delayUntilElbConnectionsDrained());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ShutdownEventConfiguration").add("ExecutionTimeout", executionTimeout())
                .add("DelayUntilElbConnectionsDrained", delayUntilElbConnectionsDrained()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutionTimeout":
            return Optional.ofNullable(clazz.cast(executionTimeout()));
        case "DelayUntilElbConnectionsDrained":
            return Optional.ofNullable(clazz.cast(delayUntilElbConnectionsDrained()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShutdownEventConfiguration, T> g) {
        return obj -> g.apply((ShutdownEventConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ShutdownEventConfiguration> {
        /**
         * <p>
         * The time, in seconds, that AWS OpsWorks Stacks will wait after triggering a Shutdown event before shutting
         * down an instance.
         * </p>
         * 
         * @param executionTimeout
         *        The time, in seconds, that AWS OpsWorks Stacks will wait after triggering a Shutdown event before
         *        shutting down an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTimeout(Integer executionTimeout);

        /**
         * <p>
         * Whether to enable Elastic Load Balancing connection draining. For more information, see <a href=
         * "https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain"
         * >Connection Draining</a>
         * </p>
         * 
         * @param delayUntilElbConnectionsDrained
         *        Whether to enable Elastic Load Balancing connection draining. For more information, see <a href=
         *        "https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain"
         *        >Connection Draining</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delayUntilElbConnectionsDrained(Boolean delayUntilElbConnectionsDrained);
    }

    static final class BuilderImpl implements Builder {
        private Integer executionTimeout;

        private Boolean delayUntilElbConnectionsDrained;

        private BuilderImpl() {
        }

        private BuilderImpl(ShutdownEventConfiguration model) {
            executionTimeout(model.executionTimeout);
            delayUntilElbConnectionsDrained(model.delayUntilElbConnectionsDrained);
        }

        public final Integer getExecutionTimeout() {
            return executionTimeout;
        }

        @Override
        public final Builder executionTimeout(Integer executionTimeout) {
            this.executionTimeout = executionTimeout;
            return this;
        }

        public final void setExecutionTimeout(Integer executionTimeout) {
            this.executionTimeout = executionTimeout;
        }

        public final Boolean getDelayUntilElbConnectionsDrained() {
            return delayUntilElbConnectionsDrained;
        }

        @Override
        public final Builder delayUntilElbConnectionsDrained(Boolean delayUntilElbConnectionsDrained) {
            this.delayUntilElbConnectionsDrained = delayUntilElbConnectionsDrained;
            return this;
        }

        public final void setDelayUntilElbConnectionsDrained(Boolean delayUntilElbConnectionsDrained) {
            this.delayUntilElbConnectionsDrained = delayUntilElbConnectionsDrained;
        }

        @Override
        public ShutdownEventConfiguration build() {
            return new ShutdownEventConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
