/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeStackProvisioningParameters</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStackProvisioningParametersResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeStackProvisioningParametersResponse.Builder, DescribeStackProvisioningParametersResponse> {
    private static final SdkField<String> AGENT_INSTALLER_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeStackProvisioningParametersResponse::agentInstallerUrl))
            .setter(setter(Builder::agentInstallerUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentInstallerUrl").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(DescribeStackProvisioningParametersResponse::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_INSTALLER_URL_FIELD,
            PARAMETERS_FIELD));

    private final String agentInstallerUrl;

    private final Map<String, String> parameters;

    private DescribeStackProvisioningParametersResponse(BuilderImpl builder) {
        super(builder);
        this.agentInstallerUrl = builder.agentInstallerUrl;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The AWS OpsWorks Stacks agent installer's URL.
     * </p>
     * 
     * @return The AWS OpsWorks Stacks agent installer's URL.
     */
    public String agentInstallerUrl() {
        return agentInstallerUrl;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An embedded object that contains the provisioning parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An embedded object that contains the provisioning parameters.
     */
    public Map<String, String> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentInstallerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackProvisioningParametersResponse)) {
            return false;
        }
        DescribeStackProvisioningParametersResponse other = (DescribeStackProvisioningParametersResponse) obj;
        return Objects.equals(agentInstallerUrl(), other.agentInstallerUrl()) && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeStackProvisioningParametersResponse").add("AgentInstallerUrl", agentInstallerUrl())
                .add("Parameters", parameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgentInstallerUrl":
            return Optional.ofNullable(clazz.cast(agentInstallerUrl()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackProvisioningParametersResponse, T> g) {
        return obj -> g.apply((DescribeStackProvisioningParametersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStackProvisioningParametersResponse> {
        /**
         * <p>
         * The AWS OpsWorks Stacks agent installer's URL.
         * </p>
         * 
         * @param agentInstallerUrl
         *        The AWS OpsWorks Stacks agent installer's URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentInstallerUrl(String agentInstallerUrl);

        /**
         * <p>
         * An embedded object that contains the provisioning parameters.
         * </p>
         * 
         * @param parameters
         *        An embedded object that contains the provisioning parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private String agentInstallerUrl;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackProvisioningParametersResponse model) {
            super(model);
            agentInstallerUrl(model.agentInstallerUrl);
            parameters(model.parameters);
        }

        public final String getAgentInstallerUrl() {
            return agentInstallerUrl;
        }

        @Override
        public final Builder agentInstallerUrl(String agentInstallerUrl) {
            this.agentInstallerUrl = agentInstallerUrl;
            return this;
        }

        public final void setAgentInstallerUrl(String agentInstallerUrl) {
            this.agentInstallerUrl = agentInstallerUrl;
        }

        public final Map<String, String> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        @Override
        public DescribeStackProvisioningParametersResponse build() {
            return new DescribeStackProvisioningParametersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
