/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRaidArraysRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DescribeRaidArraysRequest.Builder, DescribeRaidArraysRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeRaidArraysRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeRaidArraysRequest::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<List<String>> RAID_ARRAY_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeRaidArraysRequest::raidArrayIds))
            .setter(setter(Builder::raidArrayIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RaidArrayIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            STACK_ID_FIELD, RAID_ARRAY_IDS_FIELD));

    private final String instanceId;

    private final String stackId;

    private final List<String> raidArrayIds;

    private DescribeRaidArraysRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.stackId = builder.stackId;
        this.raidArrayIds = builder.raidArrayIds;
    }

    /**
     * <p>
     * The instance ID. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions of the RAID
     * arrays associated with the specified instance.
     * </p>
     * 
     * @return The instance ID. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions of the
     *         RAID arrays associated with the specified instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * Returns true if the RaidArrayIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRaidArrayIds() {
        return raidArrayIds != null && !(raidArrayIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of RAID array IDs. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions of
     * the specified arrays. Otherwise, it returns a description of every array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRaidArrayIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of RAID array IDs. If you use this parameter, <code>DescribeRaidArrays</code> returns
     *         descriptions of the specified arrays. Otherwise, it returns a description of every array.
     */
    public List<String> raidArrayIds() {
        return raidArrayIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(raidArrayIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRaidArraysRequest)) {
            return false;
        }
        DescribeRaidArraysRequest other = (DescribeRaidArraysRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(stackId(), other.stackId())
                && Objects.equals(raidArrayIds(), other.raidArrayIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeRaidArraysRequest").add("InstanceId", instanceId()).add("StackId", stackId())
                .add("RaidArrayIds", raidArrayIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "RaidArrayIds":
            return Optional.ofNullable(clazz.cast(raidArrayIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRaidArraysRequest, T> g) {
        return obj -> g.apply((DescribeRaidArraysRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRaidArraysRequest> {
        /**
         * <p>
         * The instance ID. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions of the RAID
         * arrays associated with the specified instance.
         * </p>
         * 
         * @param instanceId
         *        The instance ID. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions of
         *        the RAID arrays associated with the specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * An array of RAID array IDs. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions
         * of the specified arrays. Otherwise, it returns a description of every array.
         * </p>
         * 
         * @param raidArrayIds
         *        An array of RAID array IDs. If you use this parameter, <code>DescribeRaidArrays</code> returns
         *        descriptions of the specified arrays. Otherwise, it returns a description of every array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder raidArrayIds(Collection<String> raidArrayIds);

        /**
         * <p>
         * An array of RAID array IDs. If you use this parameter, <code>DescribeRaidArrays</code> returns descriptions
         * of the specified arrays. Otherwise, it returns a description of every array.
         * </p>
         * 
         * @param raidArrayIds
         *        An array of RAID array IDs. If you use this parameter, <code>DescribeRaidArrays</code> returns
         *        descriptions of the specified arrays. Otherwise, it returns a description of every array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder raidArrayIds(String... raidArrayIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String stackId;

        private List<String> raidArrayIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRaidArraysRequest model) {
            super(model);
            instanceId(model.instanceId);
            stackId(model.stackId);
            raidArrayIds(model.raidArrayIds);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getRaidArrayIds() {
            return raidArrayIds;
        }

        @Override
        public final Builder raidArrayIds(Collection<String> raidArrayIds) {
            this.raidArrayIds = StringsCopier.copy(raidArrayIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder raidArrayIds(String... raidArrayIds) {
            raidArrayIds(Arrays.asList(raidArrayIds));
            return this;
        }

        public final void setRaidArrayIds(Collection<String> raidArrayIds) {
            this.raidArrayIds = StringsCopier.copy(raidArrayIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRaidArraysRequest build() {
            return new DescribeRaidArraysRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
