/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.StackSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StackSummaryMarshaller {
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").isBinary(false).build();
    private static final MarshallingInfo<Integer> LAYERSCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LayersCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> APPSCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppsCount").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INSTANCESCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstancesCount").isBinary(false).build();
    private static final StackSummaryMarshaller INSTANCE = new StackSummaryMarshaller();

    private StackSummaryMarshaller() {
    }

    public static StackSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StackSummary stackSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)stackSummary, (String)"stackSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)stackSummary.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall((Object)stackSummary.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)stackSummary.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)stackSummary.layersCount(), LAYERSCOUNT_BINDING);
            protocolMarshaller.marshall((Object)stackSummary.appsCount(), APPSCOUNT_BINDING);
            protocolMarshaller.marshall((Object)stackSummary.instancesCount(), INSTANCESCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

