/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.ElasticLoadBalancer;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ElasticLoadBalancerMarshaller {
    private static final MarshallingInfo<String> ELASTICLOADBALANCERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElasticLoadBalancerName").isBinary(false).build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").isBinary(false).build();
    private static final MarshallingInfo<String> DNSNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DnsName").isBinary(false).build();
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").isBinary(false).build();
    private static final MarshallingInfo<String> LAYERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LayerId").isBinary(false).build();
    private static final MarshallingInfo<String> VPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcId").isBinary(false).build();
    private static final MarshallingInfo<List> AVAILABILITYZONES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZones").isBinary(false).build();
    private static final MarshallingInfo<List> SUBNETIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetIds").isBinary(false).build();
    private static final MarshallingInfo<List> EC2INSTANCEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ec2InstanceIds").isBinary(false).build();
    private static final ElasticLoadBalancerMarshaller INSTANCE = new ElasticLoadBalancerMarshaller();

    private ElasticLoadBalancerMarshaller() {
    }

    public static ElasticLoadBalancerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ElasticLoadBalancer elasticLoadBalancer, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)elasticLoadBalancer, (String)"elasticLoadBalancer");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)elasticLoadBalancer.elasticLoadBalancerName(), ELASTICLOADBALANCERNAME_BINDING);
            protocolMarshaller.marshall((Object)elasticLoadBalancer.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)elasticLoadBalancer.dnsName(), DNSNAME_BINDING);
            protocolMarshaller.marshall((Object)elasticLoadBalancer.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall((Object)elasticLoadBalancer.layerId(), LAYERID_BINDING);
            protocolMarshaller.marshall((Object)elasticLoadBalancer.vpcId(), VPCID_BINDING);
            protocolMarshaller.marshall(elasticLoadBalancer.availabilityZones(), AVAILABILITYZONES_BINDING);
            protocolMarshaller.marshall(elasticLoadBalancer.subnetIds(), SUBNETIDS_BINDING);
            protocolMarshaller.marshall(elasticLoadBalancer.ec2InstanceIds(), EC2INSTANCEIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

