/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetPermissionRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, SetPermissionRequest> {
    private final String stackId;
    private final String iamUserArn;
    private final Boolean allowSsh;
    private final Boolean allowSudo;
    private final String level;

    private SetPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.iamUserArn = builder.iamUserArn;
        this.allowSsh = builder.allowSsh;
        this.allowSudo = builder.allowSudo;
        this.level = builder.level;
    }

    public String stackId() {
        return this.stackId;
    }

    public String iamUserArn() {
        return this.iamUserArn;
    }

    public Boolean allowSsh() {
        return this.allowSsh;
    }

    public Boolean allowSudo() {
        return this.allowSudo;
    }

    public String level() {
        return this.level;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowSsh());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowSudo());
        hashCode = 31 * hashCode + Objects.hashCode(this.level());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetPermissionRequest)) {
            return false;
        }
        SetPermissionRequest other = (SetPermissionRequest)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.iamUserArn(), other.iamUserArn()) && Objects.equals(this.allowSsh(), other.allowSsh()) && Objects.equals(this.allowSudo(), other.allowSudo()) && Objects.equals(this.level(), other.level());
    }

    public String toString() {
        return ToString.builder((String)"SetPermissionRequest").add("StackId", (Object)this.stackId()).add("IamUserArn", (Object)this.iamUserArn()).add("AllowSsh", (Object)this.allowSsh()).add("AllowSudo", (Object)this.allowSudo()).add("Level", (Object)this.level()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "IamUserArn": {
                return Optional.of(clazz.cast(this.iamUserArn()));
            }
            case "AllowSsh": {
                return Optional.of(clazz.cast(this.allowSsh()));
            }
            case "AllowSudo": {
                return Optional.of(clazz.cast(this.allowSudo()));
            }
            case "Level": {
                return Optional.of(clazz.cast(this.level()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String stackId;
        private String iamUserArn;
        private Boolean allowSsh;
        private Boolean allowSudo;
        private String level;

        private BuilderImpl() {
        }

        private BuilderImpl(SetPermissionRequest model) {
            this.stackId(model.stackId);
            this.iamUserArn(model.iamUserArn);
            this.allowSsh(model.allowSsh);
            this.allowSudo(model.allowSudo);
            this.level(model.level);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getIamUserArn() {
            return this.iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final Boolean getAllowSsh() {
            return this.allowSsh;
        }

        @Override
        public final Builder allowSsh(Boolean allowSsh) {
            this.allowSsh = allowSsh;
            return this;
        }

        public final void setAllowSsh(Boolean allowSsh) {
            this.allowSsh = allowSsh;
        }

        public final Boolean getAllowSudo() {
            return this.allowSudo;
        }

        @Override
        public final Builder allowSudo(Boolean allowSudo) {
            this.allowSudo = allowSudo;
            return this;
        }

        public final void setAllowSudo(Boolean allowSudo) {
            this.allowSudo = allowSudo;
        }

        public final String getLevel() {
            return this.level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SetPermissionRequest build() {
            return new SetPermissionRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    CopyableBuilder<Builder, SetPermissionRequest> {
        public Builder stackId(String var1);

        public Builder iamUserArn(String var1);

        public Builder allowSsh(Boolean var1);

        public Builder allowSudo(Boolean var1);

        public Builder level(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

