/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.services.opsworks.model.Permission;
import software.amazon.awssdk.services.opsworks.model.PermissionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePermissionsResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribePermissionsResponse> {
    private final List<Permission> permissions;

    private DescribePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.permissions = builder.permissions;
    }

    public List<Permission> permissions() {
        return this.permissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.permissions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePermissionsResponse)) {
            return false;
        }
        DescribePermissionsResponse other = (DescribePermissionsResponse)((Object)obj);
        return Objects.equals(this.permissions(), other.permissions());
    }

    public String toString() {
        return ToString.builder((String)"DescribePermissionsResponse").add("Permissions", this.permissions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Permissions": {
                return Optional.of(clazz.cast(this.permissions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<Permission> permissions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePermissionsResponse model) {
            this.permissions(model.permissions);
        }

        public final Collection<Permission.Builder> getPermissions() {
            return this.permissions != null ? (Collection)this.permissions.stream().map(Permission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionsCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        public final void setPermissions(Collection<Permission.BuilderImpl> permissions) {
            this.permissions = PermissionsCopier.copyFromBuilder(permissions);
        }

        @Override
        public DescribePermissionsResponse build() {
            return new DescribePermissionsResponse(this);
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    CopyableBuilder<Builder, DescribePermissionsResponse> {
        public Builder permissions(Collection<Permission> var1);

        public Builder permissions(Permission ... var1);
    }
}

