/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.opsworks.model.AutoScalingThresholds;

public class AutoScalingThresholdsUnmarshaller
implements Unmarshaller<AutoScalingThresholds, JsonUnmarshallerContext> {
    private static final AutoScalingThresholdsUnmarshaller INSTANCE = new AutoScalingThresholdsUnmarshaller();

    public AutoScalingThresholds unmarshall(JsonUnmarshallerContext context) throws Exception {
        AutoScalingThresholds.Builder autoScalingThresholdsBuilder = AutoScalingThresholds.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("InstanceCount", targetDepth)) {
                    context.nextToken();
                    autoScalingThresholdsBuilder.instanceCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("ThresholdsWaitTime", targetDepth)) {
                    context.nextToken();
                    autoScalingThresholdsBuilder.thresholdsWaitTime((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("IgnoreMetricsTime", targetDepth)) {
                    context.nextToken();
                    autoScalingThresholdsBuilder.ignoreMetricsTime((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("CpuThreshold", targetDepth)) {
                    context.nextToken();
                    autoScalingThresholdsBuilder.cpuThreshold((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("MemoryThreshold", targetDepth)) {
                    context.nextToken();
                    autoScalingThresholdsBuilder.memoryThreshold((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("LoadThreshold", targetDepth)) {
                    context.nextToken();
                    autoScalingThresholdsBuilder.loadThreshold((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("Alarms", targetDepth)) {
                    context.nextToken();
                    autoScalingThresholdsBuilder.alarms(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AutoScalingThresholds)autoScalingThresholdsBuilder.build();
    }

    public static AutoScalingThresholdsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

