/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.CloudWatchLogsEncoding;
import software.amazon.awssdk.services.opsworks.model.CloudWatchLogsInitialPosition;
import software.amazon.awssdk.services.opsworks.model.CloudWatchLogsTimeZone;
import software.amazon.awssdk.services.opsworks.transform.CloudWatchLogsLogStreamMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloudWatchLogsLogStream
implements StructuredPojo,
ToCopyableBuilder<Builder, CloudWatchLogsLogStream> {
    private final String logGroupName;
    private final String datetimeFormat;
    private final String timeZone;
    private final String file;
    private final String fileFingerprintLines;
    private final String multiLineStartPattern;
    private final String initialPosition;
    private final String encoding;
    private final Integer bufferDuration;
    private final Integer batchCount;
    private final Integer batchSize;

    private CloudWatchLogsLogStream(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.datetimeFormat = builder.datetimeFormat;
        this.timeZone = builder.timeZone;
        this.file = builder.file;
        this.fileFingerprintLines = builder.fileFingerprintLines;
        this.multiLineStartPattern = builder.multiLineStartPattern;
        this.initialPosition = builder.initialPosition;
        this.encoding = builder.encoding;
        this.bufferDuration = builder.bufferDuration;
        this.batchCount = builder.batchCount;
        this.batchSize = builder.batchSize;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public String datetimeFormat() {
        return this.datetimeFormat;
    }

    public CloudWatchLogsTimeZone timeZone() {
        return CloudWatchLogsTimeZone.fromValue(this.timeZone);
    }

    public String timeZoneString() {
        return this.timeZone;
    }

    public String file() {
        return this.file;
    }

    public String fileFingerprintLines() {
        return this.fileFingerprintLines;
    }

    public String multiLineStartPattern() {
        return this.multiLineStartPattern;
    }

    public CloudWatchLogsInitialPosition initialPosition() {
        return CloudWatchLogsInitialPosition.fromValue(this.initialPosition);
    }

    public String initialPositionString() {
        return this.initialPosition;
    }

    public CloudWatchLogsEncoding encoding() {
        return CloudWatchLogsEncoding.fromValue(this.encoding);
    }

    public String encodingString() {
        return this.encoding;
    }

    public Integer bufferDuration() {
        return this.bufferDuration;
    }

    public Integer batchCount() {
        return this.batchCount;
    }

    public Integer batchSize() {
        return this.batchSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datetimeFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZoneString());
        hashCode = 31 * hashCode + Objects.hashCode(this.file());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileFingerprintLines());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiLineStartPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialPositionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encodingString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchSize());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogsLogStream)) {
            return false;
        }
        CloudWatchLogsLogStream other = (CloudWatchLogsLogStream)obj;
        return Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.datetimeFormat(), other.datetimeFormat()) && Objects.equals(this.timeZoneString(), other.timeZoneString()) && Objects.equals(this.file(), other.file()) && Objects.equals(this.fileFingerprintLines(), other.fileFingerprintLines()) && Objects.equals(this.multiLineStartPattern(), other.multiLineStartPattern()) && Objects.equals(this.initialPositionString(), other.initialPositionString()) && Objects.equals(this.encodingString(), other.encodingString()) && Objects.equals(this.bufferDuration(), other.bufferDuration()) && Objects.equals(this.batchCount(), other.batchCount()) && Objects.equals(this.batchSize(), other.batchSize());
    }

    public String toString() {
        return ToString.builder((String)"CloudWatchLogsLogStream").add("LogGroupName", (Object)this.logGroupName()).add("DatetimeFormat", (Object)this.datetimeFormat()).add("TimeZone", (Object)this.timeZoneString()).add("File", (Object)this.file()).add("FileFingerprintLines", (Object)this.fileFingerprintLines()).add("MultiLineStartPattern", (Object)this.multiLineStartPattern()).add("InitialPosition", (Object)this.initialPositionString()).add("Encoding", (Object)this.encodingString()).add("BufferDuration", (Object)this.bufferDuration()).add("BatchCount", (Object)this.batchCount()).add("BatchSize", (Object)this.batchSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogGroupName": {
                return Optional.of(clazz.cast(this.logGroupName()));
            }
            case "DatetimeFormat": {
                return Optional.of(clazz.cast(this.datetimeFormat()));
            }
            case "TimeZone": {
                return Optional.of(clazz.cast(this.timeZoneString()));
            }
            case "File": {
                return Optional.of(clazz.cast(this.file()));
            }
            case "FileFingerprintLines": {
                return Optional.of(clazz.cast(this.fileFingerprintLines()));
            }
            case "MultiLineStartPattern": {
                return Optional.of(clazz.cast(this.multiLineStartPattern()));
            }
            case "InitialPosition": {
                return Optional.of(clazz.cast(this.initialPositionString()));
            }
            case "Encoding": {
                return Optional.of(clazz.cast(this.encodingString()));
            }
            case "BufferDuration": {
                return Optional.of(clazz.cast(this.bufferDuration()));
            }
            case "BatchCount": {
                return Optional.of(clazz.cast(this.batchCount()));
            }
            case "BatchSize": {
                return Optional.of(clazz.cast(this.batchSize()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudWatchLogsLogStreamMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String logGroupName;
        private String datetimeFormat;
        private String timeZone;
        private String file;
        private String fileFingerprintLines;
        private String multiLineStartPattern;
        private String initialPosition;
        private String encoding;
        private Integer bufferDuration;
        private Integer batchCount;
        private Integer batchSize;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogsLogStream model) {
            this.logGroupName(model.logGroupName);
            this.datetimeFormat(model.datetimeFormat);
            this.timeZone(model.timeZone);
            this.file(model.file);
            this.fileFingerprintLines(model.fileFingerprintLines);
            this.multiLineStartPattern(model.multiLineStartPattern);
            this.initialPosition(model.initialPosition);
            this.encoding(model.encoding);
            this.bufferDuration(model.bufferDuration);
            this.batchCount(model.batchCount);
            this.batchSize(model.batchSize);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getDatetimeFormat() {
            return this.datetimeFormat;
        }

        @Override
        public final Builder datetimeFormat(String datetimeFormat) {
            this.datetimeFormat = datetimeFormat;
            return this;
        }

        public final void setDatetimeFormat(String datetimeFormat) {
            this.datetimeFormat = datetimeFormat;
        }

        public final String getTimeZone() {
            return this.timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        @Override
        public final Builder timeZone(CloudWatchLogsTimeZone timeZone) {
            this.timeZone(timeZone.toString());
            return this;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        public final String getFile() {
            return this.file;
        }

        @Override
        public final Builder file(String file) {
            this.file = file;
            return this;
        }

        public final void setFile(String file) {
            this.file = file;
        }

        public final String getFileFingerprintLines() {
            return this.fileFingerprintLines;
        }

        @Override
        public final Builder fileFingerprintLines(String fileFingerprintLines) {
            this.fileFingerprintLines = fileFingerprintLines;
            return this;
        }

        public final void setFileFingerprintLines(String fileFingerprintLines) {
            this.fileFingerprintLines = fileFingerprintLines;
        }

        public final String getMultiLineStartPattern() {
            return this.multiLineStartPattern;
        }

        @Override
        public final Builder multiLineStartPattern(String multiLineStartPattern) {
            this.multiLineStartPattern = multiLineStartPattern;
            return this;
        }

        public final void setMultiLineStartPattern(String multiLineStartPattern) {
            this.multiLineStartPattern = multiLineStartPattern;
        }

        public final String getInitialPosition() {
            return this.initialPosition;
        }

        @Override
        public final Builder initialPosition(String initialPosition) {
            this.initialPosition = initialPosition;
            return this;
        }

        @Override
        public final Builder initialPosition(CloudWatchLogsInitialPosition initialPosition) {
            this.initialPosition(initialPosition.toString());
            return this;
        }

        public final void setInitialPosition(String initialPosition) {
            this.initialPosition = initialPosition;
        }

        public final String getEncoding() {
            return this.encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        @Override
        public final Builder encoding(CloudWatchLogsEncoding encoding) {
            this.encoding(encoding.toString());
            return this;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public final Integer getBufferDuration() {
            return this.bufferDuration;
        }

        @Override
        public final Builder bufferDuration(Integer bufferDuration) {
            this.bufferDuration = bufferDuration;
            return this;
        }

        public final void setBufferDuration(Integer bufferDuration) {
            this.bufferDuration = bufferDuration;
        }

        public final Integer getBatchCount() {
            return this.batchCount;
        }

        @Override
        public final Builder batchCount(Integer batchCount) {
            this.batchCount = batchCount;
            return this;
        }

        public final void setBatchCount(Integer batchCount) {
            this.batchCount = batchCount;
        }

        public final Integer getBatchSize() {
            return this.batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        public CloudWatchLogsLogStream build() {
            return new CloudWatchLogsLogStream(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudWatchLogsLogStream> {
        public Builder logGroupName(String var1);

        public Builder datetimeFormat(String var1);

        public Builder timeZone(String var1);

        public Builder timeZone(CloudWatchLogsTimeZone var1);

        public Builder file(String var1);

        public Builder fileFingerprintLines(String var1);

        public Builder multiLineStartPattern(String var1);

        public Builder initialPosition(String var1);

        public Builder initialPosition(CloudWatchLogsInitialPosition var1);

        public Builder encoding(String var1);

        public Builder encoding(CloudWatchLogsEncoding var1);

        public Builder bufferDuration(Integer var1);

        public Builder batchCount(Integer var1);

        public Builder batchSize(Integer var1);
    }
}

