/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.AgentVersion;

@SdkInternalApi
public class AgentVersionMarshaller {
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").build();
    private static final MarshallingInfo<StructuredPojo> CONFIGURATIONMANAGER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigurationManager").build();
    private static final AgentVersionMarshaller INSTANCE = new AgentVersionMarshaller();

    public static AgentVersionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AgentVersion agentVersion, ProtocolMarshaller protocolMarshaller) {
        if (agentVersion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)agentVersion.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)agentVersion.configurationManager(), CONFIGURATIONMANAGER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

