/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.opsworks.model.CloudWatchLogsConfiguration;
import software.amazon.awssdk.services.opsworks.transform.CloudWatchLogsLogStreamUnmarshaller;

public class CloudWatchLogsConfigurationUnmarshaller
implements Unmarshaller<CloudWatchLogsConfiguration, JsonUnmarshallerContext> {
    private static final CloudWatchLogsConfigurationUnmarshaller INSTANCE = new CloudWatchLogsConfigurationUnmarshaller();

    public CloudWatchLogsConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        CloudWatchLogsConfiguration.Builder cloudWatchLogsConfigurationBuilder = CloudWatchLogsConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Enabled", targetDepth)) {
                    context.nextToken();
                    cloudWatchLogsConfigurationBuilder.enabled((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("LogStreams", targetDepth)) {
                    context.nextToken();
                    cloudWatchLogsConfigurationBuilder.logStreams(new ListUnmarshaller((Unmarshaller)CloudWatchLogsLogStreamUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (CloudWatchLogsConfiguration)cloudWatchLogsConfigurationBuilder.build();
    }

    public static CloudWatchLogsConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

