/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.InstanceIdentityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceIdentity
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceIdentity> {
    private final String document;
    private final String signature;

    private InstanceIdentity(BuilderImpl builder) {
        this.document = builder.document;
        this.signature = builder.signature;
    }

    public String document() {
        return this.document;
    }

    public String signature() {
        return this.signature;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        hashCode = 31 * hashCode + Objects.hashCode(this.signature());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceIdentity)) {
            return false;
        }
        InstanceIdentity other = (InstanceIdentity)obj;
        return Objects.equals(this.document(), other.document()) && Objects.equals(this.signature(), other.signature());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.document() != null) {
            sb.append("Document: ").append(this.document()).append(",");
        }
        if (this.signature() != null) {
            sb.append("Signature: ").append(this.signature()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Document": {
                return Optional.of(clazz.cast(this.document()));
            }
            case "Signature": {
                return Optional.of(clazz.cast(this.signature()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceIdentityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String document;
        private String signature;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceIdentity model) {
            this.document(model.document);
            this.signature(model.signature);
        }

        public final String getDocument() {
            return this.document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        public final String getSignature() {
            return this.signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        public InstanceIdentity build() {
            return new InstanceIdentity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceIdentity> {
        public Builder document(String var1);

        public Builder signature(String var1);
    }
}

