/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GrantAccessRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GrantAccessRequest> {
    private final String instanceId;
    private final Integer validForInMinutes;

    private GrantAccessRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.validForInMinutes = builder.validForInMinutes;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Integer validForInMinutes() {
        return this.validForInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.validForInMinutes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantAccessRequest)) {
            return false;
        }
        GrantAccessRequest other = (GrantAccessRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.validForInMinutes(), other.validForInMinutes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.validForInMinutes() != null) {
            sb.append("ValidForInMinutes: ").append(this.validForInMinutes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "ValidForInMinutes": {
                return Optional.of(clazz.cast(this.validForInMinutes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private Integer validForInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(GrantAccessRequest model) {
            this.instanceId(model.instanceId);
            this.validForInMinutes(model.validForInMinutes);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Integer getValidForInMinutes() {
            return this.validForInMinutes;
        }

        @Override
        public final Builder validForInMinutes(Integer validForInMinutes) {
            this.validForInMinutes = validForInMinutes;
            return this;
        }

        public final void setValidForInMinutes(Integer validForInMinutes) {
            this.validForInMinutes = validForInMinutes;
        }

        public GrantAccessRequest build() {
            return new GrantAccessRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GrantAccessRequest> {
        public Builder instanceId(String var1);

        public Builder validForInMinutes(Integer var1);
    }
}

