/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.opsworks.model.ParametersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeStackProvisioningParametersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeStackProvisioningParametersResponse> {
    private final String agentInstallerUrl;
    private final Map<String, String> parameters;

    private DescribeStackProvisioningParametersResponse(BuilderImpl builder) {
        this.agentInstallerUrl = builder.agentInstallerUrl;
        this.parameters = builder.parameters;
    }

    public String agentInstallerUrl() {
        return this.agentInstallerUrl;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentInstallerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackProvisioningParametersResponse)) {
            return false;
        }
        DescribeStackProvisioningParametersResponse other = (DescribeStackProvisioningParametersResponse)((Object)obj);
        return Objects.equals(this.agentInstallerUrl(), other.agentInstallerUrl()) && Objects.equals(this.parameters(), other.parameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.agentInstallerUrl() != null) {
            sb.append("AgentInstallerUrl: ").append(this.agentInstallerUrl()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AgentInstallerUrl": {
                return Optional.of(clazz.cast(this.agentInstallerUrl()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String agentInstallerUrl;
        private Map<String, String> parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackProvisioningParametersResponse model) {
            this.agentInstallerUrl(model.agentInstallerUrl);
            this.parameters(model.parameters);
        }

        public final String getAgentInstallerUrl() {
            return this.agentInstallerUrl;
        }

        @Override
        public final Builder agentInstallerUrl(String agentInstallerUrl) {
            this.agentInstallerUrl = agentInstallerUrl;
            return this;
        }

        public final void setAgentInstallerUrl(String agentInstallerUrl) {
            this.agentInstallerUrl = agentInstallerUrl;
        }

        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        public DescribeStackProvisioningParametersResponse build() {
            return new DescribeStackProvisioningParametersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeStackProvisioningParametersResponse> {
        public Builder agentInstallerUrl(String var1);

        public Builder parameters(Map<String, String> var1);
    }
}

