/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.opsworks.model.RaidArray;
import software.amazon.awssdk.services.opsworks.model.RaidArraysCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeRaidArraysResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeRaidArraysResponse> {
    private final List<RaidArray> raidArrays;

    private DescribeRaidArraysResponse(BuilderImpl builder) {
        this.raidArrays = builder.raidArrays;
    }

    public List<RaidArray> raidArrays() {
        return this.raidArrays;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.raidArrays());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRaidArraysResponse)) {
            return false;
        }
        DescribeRaidArraysResponse other = (DescribeRaidArraysResponse)((Object)obj);
        return Objects.equals(this.raidArrays(), other.raidArrays());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.raidArrays() != null) {
            sb.append("RaidArrays: ").append(this.raidArrays()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RaidArrays": {
                return Optional.of(clazz.cast(this.raidArrays()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<RaidArray> raidArrays;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRaidArraysResponse model) {
            this.raidArrays(model.raidArrays);
        }

        public final Collection<RaidArray.Builder> getRaidArrays() {
            return this.raidArrays != null ? (Collection)this.raidArrays.stream().map(RaidArray::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder raidArrays(Collection<RaidArray> raidArrays) {
            this.raidArrays = RaidArraysCopier.copy(raidArrays);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder raidArrays(RaidArray ... raidArrays) {
            this.raidArrays(Arrays.asList(raidArrays));
            return this;
        }

        public final void setRaidArrays(Collection<RaidArray.BuilderImpl> raidArrays) {
            this.raidArrays = RaidArraysCopier.copyFromBuilder(raidArrays);
        }

        public DescribeRaidArraysResponse build() {
            return new DescribeRaidArraysResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeRaidArraysResponse> {
        public Builder raidArrays(Collection<RaidArray> var1);

        public Builder raidArrays(RaidArray ... var1);
    }
}

