/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.opsworks.model.ElasticLoadBalancer;
import software.amazon.awssdk.services.opsworks.model.ElasticLoadBalancersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeElasticLoadBalancersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeElasticLoadBalancersResponse> {
    private final List<ElasticLoadBalancer> elasticLoadBalancers;

    private DescribeElasticLoadBalancersResponse(BuilderImpl builder) {
        this.elasticLoadBalancers = builder.elasticLoadBalancers;
    }

    public List<ElasticLoadBalancer> elasticLoadBalancers() {
        return this.elasticLoadBalancers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticLoadBalancers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticLoadBalancersResponse)) {
            return false;
        }
        DescribeElasticLoadBalancersResponse other = (DescribeElasticLoadBalancersResponse)((Object)obj);
        return Objects.equals(this.elasticLoadBalancers(), other.elasticLoadBalancers());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.elasticLoadBalancers() != null) {
            sb.append("ElasticLoadBalancers: ").append(this.elasticLoadBalancers()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElasticLoadBalancers": {
                return Optional.of(clazz.cast(this.elasticLoadBalancers()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ElasticLoadBalancer> elasticLoadBalancers;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticLoadBalancersResponse model) {
            this.elasticLoadBalancers(model.elasticLoadBalancers);
        }

        public final Collection<ElasticLoadBalancer.Builder> getElasticLoadBalancers() {
            return this.elasticLoadBalancers != null ? (Collection)this.elasticLoadBalancers.stream().map(ElasticLoadBalancer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elasticLoadBalancers(Collection<ElasticLoadBalancer> elasticLoadBalancers) {
            this.elasticLoadBalancers = ElasticLoadBalancersCopier.copy(elasticLoadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticLoadBalancers(ElasticLoadBalancer ... elasticLoadBalancers) {
            this.elasticLoadBalancers(Arrays.asList(elasticLoadBalancers));
            return this;
        }

        public final void setElasticLoadBalancers(Collection<ElasticLoadBalancer.BuilderImpl> elasticLoadBalancers) {
            this.elasticLoadBalancers = ElasticLoadBalancersCopier.copyFromBuilder(elasticLoadBalancers);
        }

        public DescribeElasticLoadBalancersResponse build() {
            return new DescribeElasticLoadBalancersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeElasticLoadBalancersResponse> {
        public Builder elasticLoadBalancers(Collection<ElasticLoadBalancer> var1);

        public Builder elasticLoadBalancers(ElasticLoadBalancer ... var1);
    }
}

