/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAppsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeAppsRequest> {
    private final String stackId;
    private final List<String> appIds;

    private DescribeAppsRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.appIds = builder.appIds;
    }

    public String stackId() {
        return this.stackId;
    }

    public List<String> appIds() {
        return this.appIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppsRequest)) {
            return false;
        }
        DescribeAppsRequest other = (DescribeAppsRequest)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.appIds(), other.appIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.appIds() != null) {
            sb.append("AppIds: ").append(this.appIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "AppIds": {
                return Optional.of(clazz.cast(this.appIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String stackId;
        private List<String> appIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppsRequest model) {
            this.stackId(model.stackId);
            this.appIds(model.appIds);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getAppIds() {
            return this.appIds;
        }

        @Override
        public final Builder appIds(Collection<String> appIds) {
            this.appIds = StringsCopier.copy(appIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appIds(String ... appIds) {
            this.appIds(Arrays.asList(appIds));
            return this;
        }

        public final void setAppIds(Collection<String> appIds) {
            this.appIds = StringsCopier.copy(appIds);
        }

        public DescribeAppsRequest build() {
            return new DescribeAppsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAppsRequest> {
        public Builder stackId(String var1);

        public Builder appIds(Collection<String> var1);

        public Builder appIds(String ... var1);
    }
}

