/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.opsworks.model.Source;

public class SourceUnmarshaller
implements Unmarshaller<Source, JsonUnmarshallerContext> {
    private static final SourceUnmarshaller INSTANCE = new SourceUnmarshaller();

    public Source unmarshall(JsonUnmarshallerContext context) throws Exception {
        Source.Builder sourceBuilder = Source.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    sourceBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Url", targetDepth)) {
                    context.nextToken();
                    sourceBuilder.url((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Username", targetDepth)) {
                    context.nextToken();
                    sourceBuilder.username((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Password", targetDepth)) {
                    context.nextToken();
                    sourceBuilder.password((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SshKey", targetDepth)) {
                    context.nextToken();
                    sourceBuilder.sshKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Revision", targetDepth)) {
                    context.nextToken();
                    sourceBuilder.revision((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Source)sourceBuilder.build();
    }

    public static SourceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

