/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.Architecture;
import software.amazon.awssdk.services.opsworks.model.AutoScalingType;
import software.amazon.awssdk.services.opsworks.model.BlockDeviceMapping;
import software.amazon.awssdk.services.opsworks.model.BlockDeviceMappingsCopier;
import software.amazon.awssdk.services.opsworks.model.ReportedOs;
import software.amazon.awssdk.services.opsworks.model.RootDeviceType;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.services.opsworks.model.VirtualizationType;
import software.amazon.awssdk.services.opsworks.transform.InstanceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Instance
implements StructuredPojo,
ToCopyableBuilder<Builder, Instance> {
    private final String agentVersion;
    private final String amiId;
    private final String architecture;
    private final String arn;
    private final String autoScalingType;
    private final String availabilityZone;
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final String createdAt;
    private final Boolean ebsOptimized;
    private final String ec2InstanceId;
    private final String ecsClusterArn;
    private final String ecsContainerInstanceArn;
    private final String elasticIp;
    private final String hostname;
    private final String infrastructureClass;
    private final Boolean installUpdatesOnBoot;
    private final String instanceId;
    private final String instanceProfileArn;
    private final String instanceType;
    private final String lastServiceErrorId;
    private final List<String> layerIds;
    private final String os;
    private final String platform;
    private final String privateDns;
    private final String privateIp;
    private final String publicDns;
    private final String publicIp;
    private final String registeredBy;
    private final String reportedAgentVersion;
    private final ReportedOs reportedOs;
    private final String rootDeviceType;
    private final String rootDeviceVolumeId;
    private final List<String> securityGroupIds;
    private final String sshHostDsaKeyFingerprint;
    private final String sshHostRsaKeyFingerprint;
    private final String sshKeyName;
    private final String stackId;
    private final String status;
    private final String subnetId;
    private final String tenancy;
    private final String virtualizationType;

    private Instance(BuilderImpl builder) {
        this.agentVersion = builder.agentVersion;
        this.amiId = builder.amiId;
        this.architecture = builder.architecture;
        this.arn = builder.arn;
        this.autoScalingType = builder.autoScalingType;
        this.availabilityZone = builder.availabilityZone;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.createdAt = builder.createdAt;
        this.ebsOptimized = builder.ebsOptimized;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.ecsClusterArn = builder.ecsClusterArn;
        this.ecsContainerInstanceArn = builder.ecsContainerInstanceArn;
        this.elasticIp = builder.elasticIp;
        this.hostname = builder.hostname;
        this.infrastructureClass = builder.infrastructureClass;
        this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
        this.instanceId = builder.instanceId;
        this.instanceProfileArn = builder.instanceProfileArn;
        this.instanceType = builder.instanceType;
        this.lastServiceErrorId = builder.lastServiceErrorId;
        this.layerIds = builder.layerIds;
        this.os = builder.os;
        this.platform = builder.platform;
        this.privateDns = builder.privateDns;
        this.privateIp = builder.privateIp;
        this.publicDns = builder.publicDns;
        this.publicIp = builder.publicIp;
        this.registeredBy = builder.registeredBy;
        this.reportedAgentVersion = builder.reportedAgentVersion;
        this.reportedOs = builder.reportedOs;
        this.rootDeviceType = builder.rootDeviceType;
        this.rootDeviceVolumeId = builder.rootDeviceVolumeId;
        this.securityGroupIds = builder.securityGroupIds;
        this.sshHostDsaKeyFingerprint = builder.sshHostDsaKeyFingerprint;
        this.sshHostRsaKeyFingerprint = builder.sshHostRsaKeyFingerprint;
        this.sshKeyName = builder.sshKeyName;
        this.stackId = builder.stackId;
        this.status = builder.status;
        this.subnetId = builder.subnetId;
        this.tenancy = builder.tenancy;
        this.virtualizationType = builder.virtualizationType;
    }

    public String agentVersion() {
        return this.agentVersion;
    }

    public String amiId() {
        return this.amiId;
    }

    public Architecture architecture() {
        return Architecture.fromValue(this.architecture);
    }

    public String architectureString() {
        return this.architecture;
    }

    public String arn() {
        return this.arn;
    }

    public AutoScalingType autoScalingType() {
        return AutoScalingType.fromValue(this.autoScalingType);
    }

    public String autoScalingTypeString() {
        return this.autoScalingType;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public String ec2InstanceId() {
        return this.ec2InstanceId;
    }

    public String ecsClusterArn() {
        return this.ecsClusterArn;
    }

    public String ecsContainerInstanceArn() {
        return this.ecsContainerInstanceArn;
    }

    public String elasticIp() {
        return this.elasticIp;
    }

    public String hostname() {
        return this.hostname;
    }

    public String infrastructureClass() {
        return this.infrastructureClass;
    }

    public Boolean installUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String instanceProfileArn() {
        return this.instanceProfileArn;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String lastServiceErrorId() {
        return this.lastServiceErrorId;
    }

    public List<String> layerIds() {
        return this.layerIds;
    }

    public String os() {
        return this.os;
    }

    public String platform() {
        return this.platform;
    }

    public String privateDns() {
        return this.privateDns;
    }

    public String privateIp() {
        return this.privateIp;
    }

    public String publicDns() {
        return this.publicDns;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public String registeredBy() {
        return this.registeredBy;
    }

    public String reportedAgentVersion() {
        return this.reportedAgentVersion;
    }

    public ReportedOs reportedOs() {
        return this.reportedOs;
    }

    public RootDeviceType rootDeviceType() {
        return RootDeviceType.fromValue(this.rootDeviceType);
    }

    public String rootDeviceTypeString() {
        return this.rootDeviceType;
    }

    public String rootDeviceVolumeId() {
        return this.rootDeviceVolumeId;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String sshHostDsaKeyFingerprint() {
        return this.sshHostDsaKeyFingerprint;
    }

    public String sshHostRsaKeyFingerprint() {
        return this.sshHostRsaKeyFingerprint;
    }

    public String sshKeyName() {
        return this.sshKeyName;
    }

    public String stackId() {
        return this.stackId;
    }

    public String status() {
        return this.status;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String tenancy() {
        return this.tenancy;
    }

    public VirtualizationType virtualizationType() {
        return VirtualizationType.fromValue(this.virtualizationType);
    }

    public String virtualizationTypeString() {
        return this.virtualizationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.agentVersion() == null ? 0 : this.agentVersion().hashCode());
        hashCode = 31 * hashCode + (this.amiId() == null ? 0 : this.amiId().hashCode());
        hashCode = 31 * hashCode + (this.architectureString() == null ? 0 : this.architectureString().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.autoScalingTypeString() == null ? 0 : this.autoScalingTypeString().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.blockDeviceMappings() == null ? 0 : this.blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.createdAt() == null ? 0 : this.createdAt().hashCode());
        hashCode = 31 * hashCode + (this.ebsOptimized() == null ? 0 : this.ebsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.ec2InstanceId() == null ? 0 : this.ec2InstanceId().hashCode());
        hashCode = 31 * hashCode + (this.ecsClusterArn() == null ? 0 : this.ecsClusterArn().hashCode());
        hashCode = 31 * hashCode + (this.ecsContainerInstanceArn() == null ? 0 : this.ecsContainerInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.elasticIp() == null ? 0 : this.elasticIp().hashCode());
        hashCode = 31 * hashCode + (this.hostname() == null ? 0 : this.hostname().hashCode());
        hashCode = 31 * hashCode + (this.infrastructureClass() == null ? 0 : this.infrastructureClass().hashCode());
        hashCode = 31 * hashCode + (this.installUpdatesOnBoot() == null ? 0 : this.installUpdatesOnBoot().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.instanceProfileArn() == null ? 0 : this.instanceProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.lastServiceErrorId() == null ? 0 : this.lastServiceErrorId().hashCode());
        hashCode = 31 * hashCode + (this.layerIds() == null ? 0 : this.layerIds().hashCode());
        hashCode = 31 * hashCode + (this.os() == null ? 0 : this.os().hashCode());
        hashCode = 31 * hashCode + (this.platform() == null ? 0 : this.platform().hashCode());
        hashCode = 31 * hashCode + (this.privateDns() == null ? 0 : this.privateDns().hashCode());
        hashCode = 31 * hashCode + (this.privateIp() == null ? 0 : this.privateIp().hashCode());
        hashCode = 31 * hashCode + (this.publicDns() == null ? 0 : this.publicDns().hashCode());
        hashCode = 31 * hashCode + (this.publicIp() == null ? 0 : this.publicIp().hashCode());
        hashCode = 31 * hashCode + (this.registeredBy() == null ? 0 : this.registeredBy().hashCode());
        hashCode = 31 * hashCode + (this.reportedAgentVersion() == null ? 0 : this.reportedAgentVersion().hashCode());
        hashCode = 31 * hashCode + (this.reportedOs() == null ? 0 : this.reportedOs().hashCode());
        hashCode = 31 * hashCode + (this.rootDeviceTypeString() == null ? 0 : this.rootDeviceTypeString().hashCode());
        hashCode = 31 * hashCode + (this.rootDeviceVolumeId() == null ? 0 : this.rootDeviceVolumeId().hashCode());
        hashCode = 31 * hashCode + (this.securityGroupIds() == null ? 0 : this.securityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.sshHostDsaKeyFingerprint() == null ? 0 : this.sshHostDsaKeyFingerprint().hashCode());
        hashCode = 31 * hashCode + (this.sshHostRsaKeyFingerprint() == null ? 0 : this.sshHostRsaKeyFingerprint().hashCode());
        hashCode = 31 * hashCode + (this.sshKeyName() == null ? 0 : this.sshKeyName().hashCode());
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.subnetId() == null ? 0 : this.subnetId().hashCode());
        hashCode = 31 * hashCode + (this.tenancy() == null ? 0 : this.tenancy().hashCode());
        hashCode = 31 * hashCode + (this.virtualizationTypeString() == null ? 0 : this.virtualizationTypeString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        if (other.agentVersion() == null ^ this.agentVersion() == null) {
            return false;
        }
        if (other.agentVersion() != null && !other.agentVersion().equals(this.agentVersion())) {
            return false;
        }
        if (other.amiId() == null ^ this.amiId() == null) {
            return false;
        }
        if (other.amiId() != null && !other.amiId().equals(this.amiId())) {
            return false;
        }
        if (other.architectureString() == null ^ this.architectureString() == null) {
            return false;
        }
        if (other.architectureString() != null && !other.architectureString().equals(this.architectureString())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.autoScalingTypeString() == null ^ this.autoScalingTypeString() == null) {
            return false;
        }
        if (other.autoScalingTypeString() != null && !other.autoScalingTypeString().equals(this.autoScalingTypeString())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.ec2InstanceId() == null ^ this.ec2InstanceId() == null) {
            return false;
        }
        if (other.ec2InstanceId() != null && !other.ec2InstanceId().equals(this.ec2InstanceId())) {
            return false;
        }
        if (other.ecsClusterArn() == null ^ this.ecsClusterArn() == null) {
            return false;
        }
        if (other.ecsClusterArn() != null && !other.ecsClusterArn().equals(this.ecsClusterArn())) {
            return false;
        }
        if (other.ecsContainerInstanceArn() == null ^ this.ecsContainerInstanceArn() == null) {
            return false;
        }
        if (other.ecsContainerInstanceArn() != null && !other.ecsContainerInstanceArn().equals(this.ecsContainerInstanceArn())) {
            return false;
        }
        if (other.elasticIp() == null ^ this.elasticIp() == null) {
            return false;
        }
        if (other.elasticIp() != null && !other.elasticIp().equals(this.elasticIp())) {
            return false;
        }
        if (other.hostname() == null ^ this.hostname() == null) {
            return false;
        }
        if (other.hostname() != null && !other.hostname().equals(this.hostname())) {
            return false;
        }
        if (other.infrastructureClass() == null ^ this.infrastructureClass() == null) {
            return false;
        }
        if (other.infrastructureClass() != null && !other.infrastructureClass().equals(this.infrastructureClass())) {
            return false;
        }
        if (other.installUpdatesOnBoot() == null ^ this.installUpdatesOnBoot() == null) {
            return false;
        }
        if (other.installUpdatesOnBoot() != null && !other.installUpdatesOnBoot().equals(this.installUpdatesOnBoot())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.instanceProfileArn() == null ^ this.instanceProfileArn() == null) {
            return false;
        }
        if (other.instanceProfileArn() != null && !other.instanceProfileArn().equals(this.instanceProfileArn())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.lastServiceErrorId() == null ^ this.lastServiceErrorId() == null) {
            return false;
        }
        if (other.lastServiceErrorId() != null && !other.lastServiceErrorId().equals(this.lastServiceErrorId())) {
            return false;
        }
        if (other.layerIds() == null ^ this.layerIds() == null) {
            return false;
        }
        if (other.layerIds() != null && !other.layerIds().equals(this.layerIds())) {
            return false;
        }
        if (other.os() == null ^ this.os() == null) {
            return false;
        }
        if (other.os() != null && !other.os().equals(this.os())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.privateDns() == null ^ this.privateDns() == null) {
            return false;
        }
        if (other.privateDns() != null && !other.privateDns().equals(this.privateDns())) {
            return false;
        }
        if (other.privateIp() == null ^ this.privateIp() == null) {
            return false;
        }
        if (other.privateIp() != null && !other.privateIp().equals(this.privateIp())) {
            return false;
        }
        if (other.publicDns() == null ^ this.publicDns() == null) {
            return false;
        }
        if (other.publicDns() != null && !other.publicDns().equals(this.publicDns())) {
            return false;
        }
        if (other.publicIp() == null ^ this.publicIp() == null) {
            return false;
        }
        if (other.publicIp() != null && !other.publicIp().equals(this.publicIp())) {
            return false;
        }
        if (other.registeredBy() == null ^ this.registeredBy() == null) {
            return false;
        }
        if (other.registeredBy() != null && !other.registeredBy().equals(this.registeredBy())) {
            return false;
        }
        if (other.reportedAgentVersion() == null ^ this.reportedAgentVersion() == null) {
            return false;
        }
        if (other.reportedAgentVersion() != null && !other.reportedAgentVersion().equals(this.reportedAgentVersion())) {
            return false;
        }
        if (other.reportedOs() == null ^ this.reportedOs() == null) {
            return false;
        }
        if (other.reportedOs() != null && !other.reportedOs().equals(this.reportedOs())) {
            return false;
        }
        if (other.rootDeviceTypeString() == null ^ this.rootDeviceTypeString() == null) {
            return false;
        }
        if (other.rootDeviceTypeString() != null && !other.rootDeviceTypeString().equals(this.rootDeviceTypeString())) {
            return false;
        }
        if (other.rootDeviceVolumeId() == null ^ this.rootDeviceVolumeId() == null) {
            return false;
        }
        if (other.rootDeviceVolumeId() != null && !other.rootDeviceVolumeId().equals(this.rootDeviceVolumeId())) {
            return false;
        }
        if (other.securityGroupIds() == null ^ this.securityGroupIds() == null) {
            return false;
        }
        if (other.securityGroupIds() != null && !other.securityGroupIds().equals(this.securityGroupIds())) {
            return false;
        }
        if (other.sshHostDsaKeyFingerprint() == null ^ this.sshHostDsaKeyFingerprint() == null) {
            return false;
        }
        if (other.sshHostDsaKeyFingerprint() != null && !other.sshHostDsaKeyFingerprint().equals(this.sshHostDsaKeyFingerprint())) {
            return false;
        }
        if (other.sshHostRsaKeyFingerprint() == null ^ this.sshHostRsaKeyFingerprint() == null) {
            return false;
        }
        if (other.sshHostRsaKeyFingerprint() != null && !other.sshHostRsaKeyFingerprint().equals(this.sshHostRsaKeyFingerprint())) {
            return false;
        }
        if (other.sshKeyName() == null ^ this.sshKeyName() == null) {
            return false;
        }
        if (other.sshKeyName() != null && !other.sshKeyName().equals(this.sshKeyName())) {
            return false;
        }
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.tenancy() == null ^ this.tenancy() == null) {
            return false;
        }
        if (other.tenancy() != null && !other.tenancy().equals(this.tenancy())) {
            return false;
        }
        if (other.virtualizationTypeString() == null ^ this.virtualizationTypeString() == null) {
            return false;
        }
        return other.virtualizationTypeString() == null || other.virtualizationTypeString().equals(this.virtualizationTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.agentVersion() != null) {
            sb.append("AgentVersion: ").append(this.agentVersion()).append(",");
        }
        if (this.amiId() != null) {
            sb.append("AmiId: ").append(this.amiId()).append(",");
        }
        if (this.architectureString() != null) {
            sb.append("Architecture: ").append(this.architectureString()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.autoScalingTypeString() != null) {
            sb.append("AutoScalingType: ").append(this.autoScalingTypeString()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.blockDeviceMappings()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (this.ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.ebsOptimized()).append(",");
        }
        if (this.ec2InstanceId() != null) {
            sb.append("Ec2InstanceId: ").append(this.ec2InstanceId()).append(",");
        }
        if (this.ecsClusterArn() != null) {
            sb.append("EcsClusterArn: ").append(this.ecsClusterArn()).append(",");
        }
        if (this.ecsContainerInstanceArn() != null) {
            sb.append("EcsContainerInstanceArn: ").append(this.ecsContainerInstanceArn()).append(",");
        }
        if (this.elasticIp() != null) {
            sb.append("ElasticIp: ").append(this.elasticIp()).append(",");
        }
        if (this.hostname() != null) {
            sb.append("Hostname: ").append(this.hostname()).append(",");
        }
        if (this.infrastructureClass() != null) {
            sb.append("InfrastructureClass: ").append(this.infrastructureClass()).append(",");
        }
        if (this.installUpdatesOnBoot() != null) {
            sb.append("InstallUpdatesOnBoot: ").append(this.installUpdatesOnBoot()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.instanceProfileArn() != null) {
            sb.append("InstanceProfileArn: ").append(this.instanceProfileArn()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.lastServiceErrorId() != null) {
            sb.append("LastServiceErrorId: ").append(this.lastServiceErrorId()).append(",");
        }
        if (this.layerIds() != null) {
            sb.append("LayerIds: ").append(this.layerIds()).append(",");
        }
        if (this.os() != null) {
            sb.append("Os: ").append(this.os()).append(",");
        }
        if (this.platform() != null) {
            sb.append("Platform: ").append(this.platform()).append(",");
        }
        if (this.privateDns() != null) {
            sb.append("PrivateDns: ").append(this.privateDns()).append(",");
        }
        if (this.privateIp() != null) {
            sb.append("PrivateIp: ").append(this.privateIp()).append(",");
        }
        if (this.publicDns() != null) {
            sb.append("PublicDns: ").append(this.publicDns()).append(",");
        }
        if (this.publicIp() != null) {
            sb.append("PublicIp: ").append(this.publicIp()).append(",");
        }
        if (this.registeredBy() != null) {
            sb.append("RegisteredBy: ").append(this.registeredBy()).append(",");
        }
        if (this.reportedAgentVersion() != null) {
            sb.append("ReportedAgentVersion: ").append(this.reportedAgentVersion()).append(",");
        }
        if (this.reportedOs() != null) {
            sb.append("ReportedOs: ").append(this.reportedOs()).append(",");
        }
        if (this.rootDeviceTypeString() != null) {
            sb.append("RootDeviceType: ").append(this.rootDeviceTypeString()).append(",");
        }
        if (this.rootDeviceVolumeId() != null) {
            sb.append("RootDeviceVolumeId: ").append(this.rootDeviceVolumeId()).append(",");
        }
        if (this.securityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.securityGroupIds()).append(",");
        }
        if (this.sshHostDsaKeyFingerprint() != null) {
            sb.append("SshHostDsaKeyFingerprint: ").append(this.sshHostDsaKeyFingerprint()).append(",");
        }
        if (this.sshHostRsaKeyFingerprint() != null) {
            sb.append("SshHostRsaKeyFingerprint: ").append(this.sshHostRsaKeyFingerprint()).append(",");
        }
        if (this.sshKeyName() != null) {
            sb.append("SshKeyName: ").append(this.sshKeyName()).append(",");
        }
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (this.tenancy() != null) {
            sb.append("Tenancy: ").append(this.tenancy()).append(",");
        }
        if (this.virtualizationTypeString() != null) {
            sb.append("VirtualizationType: ").append(this.virtualizationTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AgentVersion": {
                return Optional.of(clazz.cast(this.agentVersion()));
            }
            case "AmiId": {
                return Optional.of(clazz.cast(this.amiId()));
            }
            case "Architecture": {
                return Optional.of(clazz.cast(this.architectureString()));
            }
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "AutoScalingType": {
                return Optional.of(clazz.cast(this.autoScalingTypeString()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "BlockDeviceMappings": {
                return Optional.of(clazz.cast(this.blockDeviceMappings()));
            }
            case "CreatedAt": {
                return Optional.of(clazz.cast(this.createdAt()));
            }
            case "EbsOptimized": {
                return Optional.of(clazz.cast(this.ebsOptimized()));
            }
            case "Ec2InstanceId": {
                return Optional.of(clazz.cast(this.ec2InstanceId()));
            }
            case "EcsClusterArn": {
                return Optional.of(clazz.cast(this.ecsClusterArn()));
            }
            case "EcsContainerInstanceArn": {
                return Optional.of(clazz.cast(this.ecsContainerInstanceArn()));
            }
            case "ElasticIp": {
                return Optional.of(clazz.cast(this.elasticIp()));
            }
            case "Hostname": {
                return Optional.of(clazz.cast(this.hostname()));
            }
            case "InfrastructureClass": {
                return Optional.of(clazz.cast(this.infrastructureClass()));
            }
            case "InstallUpdatesOnBoot": {
                return Optional.of(clazz.cast(this.installUpdatesOnBoot()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "InstanceProfileArn": {
                return Optional.of(clazz.cast(this.instanceProfileArn()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "LastServiceErrorId": {
                return Optional.of(clazz.cast(this.lastServiceErrorId()));
            }
            case "LayerIds": {
                return Optional.of(clazz.cast(this.layerIds()));
            }
            case "Os": {
                return Optional.of(clazz.cast(this.os()));
            }
            case "Platform": {
                return Optional.of(clazz.cast(this.platform()));
            }
            case "PrivateDns": {
                return Optional.of(clazz.cast(this.privateDns()));
            }
            case "PrivateIp": {
                return Optional.of(clazz.cast(this.privateIp()));
            }
            case "PublicDns": {
                return Optional.of(clazz.cast(this.publicDns()));
            }
            case "PublicIp": {
                return Optional.of(clazz.cast(this.publicIp()));
            }
            case "RegisteredBy": {
                return Optional.of(clazz.cast(this.registeredBy()));
            }
            case "ReportedAgentVersion": {
                return Optional.of(clazz.cast(this.reportedAgentVersion()));
            }
            case "ReportedOs": {
                return Optional.of(clazz.cast(this.reportedOs()));
            }
            case "RootDeviceType": {
                return Optional.of(clazz.cast(this.rootDeviceTypeString()));
            }
            case "RootDeviceVolumeId": {
                return Optional.of(clazz.cast(this.rootDeviceVolumeId()));
            }
            case "SecurityGroupIds": {
                return Optional.of(clazz.cast(this.securityGroupIds()));
            }
            case "SshHostDsaKeyFingerprint": {
                return Optional.of(clazz.cast(this.sshHostDsaKeyFingerprint()));
            }
            case "SshHostRsaKeyFingerprint": {
                return Optional.of(clazz.cast(this.sshHostRsaKeyFingerprint()));
            }
            case "SshKeyName": {
                return Optional.of(clazz.cast(this.sshKeyName()));
            }
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
            case "Tenancy": {
                return Optional.of(clazz.cast(this.tenancy()));
            }
            case "VirtualizationType": {
                return Optional.of(clazz.cast(this.virtualizationTypeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String agentVersion;
        private String amiId;
        private String architecture;
        private String arn;
        private String autoScalingType;
        private String availabilityZone;
        private List<BlockDeviceMapping> blockDeviceMappings;
        private String createdAt;
        private Boolean ebsOptimized;
        private String ec2InstanceId;
        private String ecsClusterArn;
        private String ecsContainerInstanceArn;
        private String elasticIp;
        private String hostname;
        private String infrastructureClass;
        private Boolean installUpdatesOnBoot;
        private String instanceId;
        private String instanceProfileArn;
        private String instanceType;
        private String lastServiceErrorId;
        private List<String> layerIds;
        private String os;
        private String platform;
        private String privateDns;
        private String privateIp;
        private String publicDns;
        private String publicIp;
        private String registeredBy;
        private String reportedAgentVersion;
        private ReportedOs reportedOs;
        private String rootDeviceType;
        private String rootDeviceVolumeId;
        private List<String> securityGroupIds;
        private String sshHostDsaKeyFingerprint;
        private String sshHostRsaKeyFingerprint;
        private String sshKeyName;
        private String stackId;
        private String status;
        private String subnetId;
        private String tenancy;
        private String virtualizationType;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            this.agentVersion(model.agentVersion);
            this.amiId(model.amiId);
            this.architecture(model.architecture);
            this.arn(model.arn);
            this.autoScalingType(model.autoScalingType);
            this.availabilityZone(model.availabilityZone);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.createdAt(model.createdAt);
            this.ebsOptimized(model.ebsOptimized);
            this.ec2InstanceId(model.ec2InstanceId);
            this.ecsClusterArn(model.ecsClusterArn);
            this.ecsContainerInstanceArn(model.ecsContainerInstanceArn);
            this.elasticIp(model.elasticIp);
            this.hostname(model.hostname);
            this.infrastructureClass(model.infrastructureClass);
            this.installUpdatesOnBoot(model.installUpdatesOnBoot);
            this.instanceId(model.instanceId);
            this.instanceProfileArn(model.instanceProfileArn);
            this.instanceType(model.instanceType);
            this.lastServiceErrorId(model.lastServiceErrorId);
            this.layerIds(model.layerIds);
            this.os(model.os);
            this.platform(model.platform);
            this.privateDns(model.privateDns);
            this.privateIp(model.privateIp);
            this.publicDns(model.publicDns);
            this.publicIp(model.publicIp);
            this.registeredBy(model.registeredBy);
            this.reportedAgentVersion(model.reportedAgentVersion);
            this.reportedOs(model.reportedOs);
            this.rootDeviceType(model.rootDeviceType);
            this.rootDeviceVolumeId(model.rootDeviceVolumeId);
            this.securityGroupIds(model.securityGroupIds);
            this.sshHostDsaKeyFingerprint(model.sshHostDsaKeyFingerprint);
            this.sshHostRsaKeyFingerprint(model.sshHostRsaKeyFingerprint);
            this.sshKeyName(model.sshKeyName);
            this.stackId(model.stackId);
            this.status(model.status);
            this.subnetId(model.subnetId);
            this.tenancy(model.tenancy);
            this.virtualizationType(model.virtualizationType);
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        public final String getAmiId() {
            return this.amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getAutoScalingType() {
            return this.autoScalingType;
        }

        @Override
        public final Builder autoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
            return this;
        }

        @Override
        public final Builder autoScalingType(AutoScalingType autoScalingType) {
            this.autoScalingType(autoScalingType.toString());
            return this;
        }

        public final void setAutoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return this.blockDeviceMappings != null ? (Collection)this.blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final String getEc2InstanceId() {
            return this.ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        public final String getEcsClusterArn() {
            return this.ecsClusterArn;
        }

        @Override
        public final Builder ecsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
            return this;
        }

        public final void setEcsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
        }

        public final String getEcsContainerInstanceArn() {
            return this.ecsContainerInstanceArn;
        }

        @Override
        public final Builder ecsContainerInstanceArn(String ecsContainerInstanceArn) {
            this.ecsContainerInstanceArn = ecsContainerInstanceArn;
            return this;
        }

        public final void setEcsContainerInstanceArn(String ecsContainerInstanceArn) {
            this.ecsContainerInstanceArn = ecsContainerInstanceArn;
        }

        public final String getElasticIp() {
            return this.elasticIp;
        }

        @Override
        public final Builder elasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
            return this;
        }

        public final void setElasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
        }

        public final String getHostname() {
            return this.hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getInfrastructureClass() {
            return this.infrastructureClass;
        }

        @Override
        public final Builder infrastructureClass(String infrastructureClass) {
            this.infrastructureClass = infrastructureClass;
            return this;
        }

        public final void setInfrastructureClass(String infrastructureClass) {
            this.infrastructureClass = infrastructureClass;
        }

        public final Boolean getInstallUpdatesOnBoot() {
            return this.installUpdatesOnBoot;
        }

        @Override
        public final Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        public final void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceProfileArn() {
            return this.instanceProfileArn;
        }

        @Override
        public final Builder instanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        public final void setInstanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getLastServiceErrorId() {
            return this.lastServiceErrorId;
        }

        @Override
        public final Builder lastServiceErrorId(String lastServiceErrorId) {
            this.lastServiceErrorId = lastServiceErrorId;
            return this;
        }

        public final void setLastServiceErrorId(String lastServiceErrorId) {
            this.lastServiceErrorId = lastServiceErrorId;
        }

        public final Collection<String> getLayerIds() {
            return this.layerIds;
        }

        @Override
        public final Builder layerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerIds(String ... layerIds) {
            this.layerIds(Arrays.asList(layerIds));
            return this;
        }

        public final void setLayerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
        }

        public final String getOs() {
            return this.os;
        }

        @Override
        public final Builder os(String os) {
            this.os = os;
            return this;
        }

        public final void setOs(String os) {
            this.os = os;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getPrivateDns() {
            return this.privateDns;
        }

        @Override
        public final Builder privateDns(String privateDns) {
            this.privateDns = privateDns;
            return this;
        }

        public final void setPrivateDns(String privateDns) {
            this.privateDns = privateDns;
        }

        public final String getPrivateIp() {
            return this.privateIp;
        }

        @Override
        public final Builder privateIp(String privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public final void setPrivateIp(String privateIp) {
            this.privateIp = privateIp;
        }

        public final String getPublicDns() {
            return this.publicDns;
        }

        @Override
        public final Builder publicDns(String publicDns) {
            this.publicDns = publicDns;
            return this;
        }

        public final void setPublicDns(String publicDns) {
            this.publicDns = publicDns;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getRegisteredBy() {
            return this.registeredBy;
        }

        @Override
        public final Builder registeredBy(String registeredBy) {
            this.registeredBy = registeredBy;
            return this;
        }

        public final void setRegisteredBy(String registeredBy) {
            this.registeredBy = registeredBy;
        }

        public final String getReportedAgentVersion() {
            return this.reportedAgentVersion;
        }

        @Override
        public final Builder reportedAgentVersion(String reportedAgentVersion) {
            this.reportedAgentVersion = reportedAgentVersion;
            return this;
        }

        public final void setReportedAgentVersion(String reportedAgentVersion) {
            this.reportedAgentVersion = reportedAgentVersion;
        }

        public final ReportedOs.Builder getReportedOs() {
            return this.reportedOs != null ? this.reportedOs.toBuilder() : null;
        }

        @Override
        public final Builder reportedOs(ReportedOs reportedOs) {
            this.reportedOs = reportedOs;
            return this;
        }

        public final void setReportedOs(ReportedOs.BuilderImpl reportedOs) {
            this.reportedOs = reportedOs != null ? reportedOs.build() : null;
        }

        public final String getRootDeviceType() {
            return this.rootDeviceType;
        }

        @Override
        public final Builder rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        @Override
        public final Builder rootDeviceType(RootDeviceType rootDeviceType) {
            this.rootDeviceType(rootDeviceType.toString());
            return this;
        }

        public final void setRootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
        }

        public final String getRootDeviceVolumeId() {
            return this.rootDeviceVolumeId;
        }

        @Override
        public final Builder rootDeviceVolumeId(String rootDeviceVolumeId) {
            this.rootDeviceVolumeId = rootDeviceVolumeId;
            return this;
        }

        public final void setRootDeviceVolumeId(String rootDeviceVolumeId) {
            this.rootDeviceVolumeId = rootDeviceVolumeId;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
        }

        public final String getSshHostDsaKeyFingerprint() {
            return this.sshHostDsaKeyFingerprint;
        }

        @Override
        public final Builder sshHostDsaKeyFingerprint(String sshHostDsaKeyFingerprint) {
            this.sshHostDsaKeyFingerprint = sshHostDsaKeyFingerprint;
            return this;
        }

        public final void setSshHostDsaKeyFingerprint(String sshHostDsaKeyFingerprint) {
            this.sshHostDsaKeyFingerprint = sshHostDsaKeyFingerprint;
        }

        public final String getSshHostRsaKeyFingerprint() {
            return this.sshHostRsaKeyFingerprint;
        }

        @Override
        public final Builder sshHostRsaKeyFingerprint(String sshHostRsaKeyFingerprint) {
            this.sshHostRsaKeyFingerprint = sshHostRsaKeyFingerprint;
            return this;
        }

        public final void setSshHostRsaKeyFingerprint(String sshHostRsaKeyFingerprint) {
            this.sshHostRsaKeyFingerprint = sshHostRsaKeyFingerprint;
        }

        public final String getSshKeyName() {
            return this.sshKeyName;
        }

        @Override
        public final Builder sshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
            return this;
        }

        public final void setSshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public final String getVirtualizationType() {
            return this.virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        @Override
        public final Builder virtualizationType(VirtualizationType virtualizationType) {
            this.virtualizationType(virtualizationType.toString());
            return this;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        public Instance build() {
            return new Instance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Instance> {
        public Builder agentVersion(String var1);

        public Builder amiId(String var1);

        public Builder architecture(String var1);

        public Builder architecture(Architecture var1);

        public Builder arn(String var1);

        public Builder autoScalingType(String var1);

        public Builder autoScalingType(AutoScalingType var1);

        public Builder availabilityZone(String var1);

        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder createdAt(String var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder ec2InstanceId(String var1);

        public Builder ecsClusterArn(String var1);

        public Builder ecsContainerInstanceArn(String var1);

        public Builder elasticIp(String var1);

        public Builder hostname(String var1);

        public Builder infrastructureClass(String var1);

        public Builder installUpdatesOnBoot(Boolean var1);

        public Builder instanceId(String var1);

        public Builder instanceProfileArn(String var1);

        public Builder instanceType(String var1);

        public Builder lastServiceErrorId(String var1);

        public Builder layerIds(Collection<String> var1);

        public Builder layerIds(String ... var1);

        public Builder os(String var1);

        public Builder platform(String var1);

        public Builder privateDns(String var1);

        public Builder privateIp(String var1);

        public Builder publicDns(String var1);

        public Builder publicIp(String var1);

        public Builder registeredBy(String var1);

        public Builder reportedAgentVersion(String var1);

        public Builder reportedOs(ReportedOs var1);

        public Builder rootDeviceType(String var1);

        public Builder rootDeviceType(RootDeviceType var1);

        public Builder rootDeviceVolumeId(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder sshHostDsaKeyFingerprint(String var1);

        public Builder sshHostRsaKeyFingerprint(String var1);

        public Builder sshKeyName(String var1);

        public Builder stackId(String var1);

        public Builder status(String var1);

        public Builder subnetId(String var1);

        public Builder tenancy(String var1);

        public Builder virtualizationType(String var1);

        public Builder virtualizationType(VirtualizationType var1);
    }
}

