/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.services.opsworks.transform.ElasticLoadBalancerMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ElasticLoadBalancer
implements StructuredPojo,
ToCopyableBuilder<Builder, ElasticLoadBalancer> {
    private final String elasticLoadBalancerName;
    private final String region;
    private final String dnsName;
    private final String stackId;
    private final String layerId;
    private final String vpcId;
    private final List<String> availabilityZones;
    private final List<String> subnetIds;
    private final List<String> ec2InstanceIds;

    private ElasticLoadBalancer(BuilderImpl builder) {
        this.elasticLoadBalancerName = builder.elasticLoadBalancerName;
        this.region = builder.region;
        this.dnsName = builder.dnsName;
        this.stackId = builder.stackId;
        this.layerId = builder.layerId;
        this.vpcId = builder.vpcId;
        this.availabilityZones = builder.availabilityZones;
        this.subnetIds = builder.subnetIds;
        this.ec2InstanceIds = builder.ec2InstanceIds;
    }

    public String elasticLoadBalancerName() {
        return this.elasticLoadBalancerName;
    }

    public String region() {
        return this.region;
    }

    public String dnsName() {
        return this.dnsName;
    }

    public String stackId() {
        return this.stackId;
    }

    public String layerId() {
        return this.layerId;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public List<String> ec2InstanceIds() {
        return this.ec2InstanceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.elasticLoadBalancerName() == null ? 0 : this.elasticLoadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.region() == null ? 0 : this.region().hashCode());
        hashCode = 31 * hashCode + (this.dnsName() == null ? 0 : this.dnsName().hashCode());
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.layerId() == null ? 0 : this.layerId().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZones() == null ? 0 : this.availabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.subnetIds() == null ? 0 : this.subnetIds().hashCode());
        hashCode = 31 * hashCode + (this.ec2InstanceIds() == null ? 0 : this.ec2InstanceIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticLoadBalancer)) {
            return false;
        }
        ElasticLoadBalancer other = (ElasticLoadBalancer)obj;
        if (other.elasticLoadBalancerName() == null ^ this.elasticLoadBalancerName() == null) {
            return false;
        }
        if (other.elasticLoadBalancerName() != null && !other.elasticLoadBalancerName().equals(this.elasticLoadBalancerName())) {
            return false;
        }
        if (other.region() == null ^ this.region() == null) {
            return false;
        }
        if (other.region() != null && !other.region().equals(this.region())) {
            return false;
        }
        if (other.dnsName() == null ^ this.dnsName() == null) {
            return false;
        }
        if (other.dnsName() != null && !other.dnsName().equals(this.dnsName())) {
            return false;
        }
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.layerId() == null ^ this.layerId() == null) {
            return false;
        }
        if (other.layerId() != null && !other.layerId().equals(this.layerId())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.availabilityZones() == null ^ this.availabilityZones() == null) {
            return false;
        }
        if (other.availabilityZones() != null && !other.availabilityZones().equals(this.availabilityZones())) {
            return false;
        }
        if (other.subnetIds() == null ^ this.subnetIds() == null) {
            return false;
        }
        if (other.subnetIds() != null && !other.subnetIds().equals(this.subnetIds())) {
            return false;
        }
        if (other.ec2InstanceIds() == null ^ this.ec2InstanceIds() == null) {
            return false;
        }
        return other.ec2InstanceIds() == null || other.ec2InstanceIds().equals(this.ec2InstanceIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.elasticLoadBalancerName() != null) {
            sb.append("ElasticLoadBalancerName: ").append(this.elasticLoadBalancerName()).append(",");
        }
        if (this.region() != null) {
            sb.append("Region: ").append(this.region()).append(",");
        }
        if (this.dnsName() != null) {
            sb.append("DnsName: ").append(this.dnsName()).append(",");
        }
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.layerId() != null) {
            sb.append("LayerId: ").append(this.layerId()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.availabilityZones()).append(",");
        }
        if (this.subnetIds() != null) {
            sb.append("SubnetIds: ").append(this.subnetIds()).append(",");
        }
        if (this.ec2InstanceIds() != null) {
            sb.append("Ec2InstanceIds: ").append(this.ec2InstanceIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElasticLoadBalancerName": {
                return Optional.of(clazz.cast(this.elasticLoadBalancerName()));
            }
            case "Region": {
                return Optional.of(clazz.cast(this.region()));
            }
            case "DnsName": {
                return Optional.of(clazz.cast(this.dnsName()));
            }
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "LayerId": {
                return Optional.of(clazz.cast(this.layerId()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "AvailabilityZones": {
                return Optional.of(clazz.cast(this.availabilityZones()));
            }
            case "SubnetIds": {
                return Optional.of(clazz.cast(this.subnetIds()));
            }
            case "Ec2InstanceIds": {
                return Optional.of(clazz.cast(this.ec2InstanceIds()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticLoadBalancerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String elasticLoadBalancerName;
        private String region;
        private String dnsName;
        private String stackId;
        private String layerId;
        private String vpcId;
        private List<String> availabilityZones;
        private List<String> subnetIds;
        private List<String> ec2InstanceIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticLoadBalancer model) {
            this.elasticLoadBalancerName(model.elasticLoadBalancerName);
            this.region(model.region);
            this.dnsName(model.dnsName);
            this.stackId(model.stackId);
            this.layerId(model.layerId);
            this.vpcId(model.vpcId);
            this.availabilityZones(model.availabilityZones);
            this.subnetIds(model.subnetIds);
            this.ec2InstanceIds(model.ec2InstanceIds);
        }

        public final String getElasticLoadBalancerName() {
            return this.elasticLoadBalancerName;
        }

        @Override
        public final Builder elasticLoadBalancerName(String elasticLoadBalancerName) {
            this.elasticLoadBalancerName = elasticLoadBalancerName;
            return this;
        }

        public final void setElasticLoadBalancerName(String elasticLoadBalancerName) {
            this.elasticLoadBalancerName = elasticLoadBalancerName;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getLayerId() {
            return this.layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringsCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringsCopier.copy(availabilityZones);
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
        }

        public final Collection<String> getEc2InstanceIds() {
            return this.ec2InstanceIds;
        }

        @Override
        public final Builder ec2InstanceIds(Collection<String> ec2InstanceIds) {
            this.ec2InstanceIds = StringsCopier.copy(ec2InstanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceIds(String ... ec2InstanceIds) {
            this.ec2InstanceIds(Arrays.asList(ec2InstanceIds));
            return this;
        }

        public final void setEc2InstanceIds(Collection<String> ec2InstanceIds) {
            this.ec2InstanceIds = StringsCopier.copy(ec2InstanceIds);
        }

        public ElasticLoadBalancer build() {
            return new ElasticLoadBalancer(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ElasticLoadBalancer> {
        public Builder elasticLoadBalancerName(String var1);

        public Builder region(String var1);

        public Builder dnsName(String var1);

        public Builder stackId(String var1);

        public Builder layerId(String var1);

        public Builder vpcId(String var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder ec2InstanceIds(Collection<String> var1);

        public Builder ec2InstanceIds(String ... var1);
    }
}

