/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.EbsBlockDevice;
import software.amazon.awssdk.services.opsworks.transform.BlockDeviceMappingMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BlockDeviceMapping
implements StructuredPojo,
ToCopyableBuilder<Builder, BlockDeviceMapping> {
    private final String deviceName;
    private final String noDevice;
    private final String virtualName;
    private final EbsBlockDevice ebs;

    private BlockDeviceMapping(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.noDevice = builder.noDevice;
        this.virtualName = builder.virtualName;
        this.ebs = builder.ebs;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public String noDevice() {
        return this.noDevice;
    }

    public String virtualName() {
        return this.virtualName;
    }

    public EbsBlockDevice ebs() {
        return this.ebs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deviceName() == null ? 0 : this.deviceName().hashCode());
        hashCode = 31 * hashCode + (this.noDevice() == null ? 0 : this.noDevice().hashCode());
        hashCode = 31 * hashCode + (this.virtualName() == null ? 0 : this.virtualName().hashCode());
        hashCode = 31 * hashCode + (this.ebs() == null ? 0 : this.ebs().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockDeviceMapping)) {
            return false;
        }
        BlockDeviceMapping other = (BlockDeviceMapping)obj;
        if (other.deviceName() == null ^ this.deviceName() == null) {
            return false;
        }
        if (other.deviceName() != null && !other.deviceName().equals(this.deviceName())) {
            return false;
        }
        if (other.noDevice() == null ^ this.noDevice() == null) {
            return false;
        }
        if (other.noDevice() != null && !other.noDevice().equals(this.noDevice())) {
            return false;
        }
        if (other.virtualName() == null ^ this.virtualName() == null) {
            return false;
        }
        if (other.virtualName() != null && !other.virtualName().equals(this.virtualName())) {
            return false;
        }
        if (other.ebs() == null ^ this.ebs() == null) {
            return false;
        }
        return other.ebs() == null || other.ebs().equals(this.ebs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deviceName() != null) {
            sb.append("DeviceName: ").append(this.deviceName()).append(",");
        }
        if (this.noDevice() != null) {
            sb.append("NoDevice: ").append(this.noDevice()).append(",");
        }
        if (this.virtualName() != null) {
            sb.append("VirtualName: ").append(this.virtualName()).append(",");
        }
        if (this.ebs() != null) {
            sb.append("Ebs: ").append(this.ebs()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceName": {
                return Optional.of(clazz.cast(this.deviceName()));
            }
            case "NoDevice": {
                return Optional.of(clazz.cast(this.noDevice()));
            }
            case "VirtualName": {
                return Optional.of(clazz.cast(this.virtualName()));
            }
            case "Ebs": {
                return Optional.of(clazz.cast(this.ebs()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BlockDeviceMappingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceName;
        private String noDevice;
        private String virtualName;
        private EbsBlockDevice ebs;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockDeviceMapping model) {
            this.deviceName(model.deviceName);
            this.noDevice(model.noDevice);
            this.virtualName(model.virtualName);
            this.ebs(model.ebs);
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getNoDevice() {
            return this.noDevice;
        }

        @Override
        public final Builder noDevice(String noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final void setNoDevice(String noDevice) {
            this.noDevice = noDevice;
        }

        public final String getVirtualName() {
            return this.virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        public final EbsBlockDevice.Builder getEbs() {
            return this.ebs != null ? this.ebs.toBuilder() : null;
        }

        @Override
        public final Builder ebs(EbsBlockDevice ebs) {
            this.ebs = ebs;
            return this;
        }

        public final void setEbs(EbsBlockDevice.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        public BlockDeviceMapping build() {
            return new BlockDeviceMapping(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BlockDeviceMapping> {
        public Builder deviceName(String var1);

        public Builder noDevice(String var1);

        public Builder virtualName(String var1);

        public Builder ebs(EbsBlockDevice var1);
    }
}

