/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.opsworks.model.BlockDeviceMapping;
import software.amazon.awssdk.services.opsworks.transform.EbsBlockDeviceUnmarshaller;

public class BlockDeviceMappingUnmarshaller
implements Unmarshaller<BlockDeviceMapping, JsonUnmarshallerContext> {
    private static final BlockDeviceMappingUnmarshaller INSTANCE = new BlockDeviceMappingUnmarshaller();

    public BlockDeviceMapping unmarshall(JsonUnmarshallerContext context) throws Exception {
        BlockDeviceMapping.Builder blockDeviceMappingBuilder = BlockDeviceMapping.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("DeviceName", targetDepth)) {
                    context.nextToken();
                    blockDeviceMappingBuilder.deviceName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("NoDevice", targetDepth)) {
                    context.nextToken();
                    blockDeviceMappingBuilder.noDevice((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("VirtualName", targetDepth)) {
                    context.nextToken();
                    blockDeviceMappingBuilder.virtualName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Ebs", targetDepth)) {
                    context.nextToken();
                    blockDeviceMappingBuilder.ebs(EbsBlockDeviceUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (BlockDeviceMapping)blockDeviceMappingBuilder.build();
    }

    public static BlockDeviceMappingUnmarshaller getInstance() {
        return INSTANCE;
    }
}

