/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.opsworks.model.Command;
import software.amazon.awssdk.services.opsworks.model.CommandsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCommandsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeCommandsResponse> {
    private final List<Command> commands;

    private DescribeCommandsResponse(BuilderImpl builder) {
        this.commands = builder.commands;
    }

    public List<Command> commands() {
        return this.commands;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.commands() == null ? 0 : this.commands().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommandsResponse)) {
            return false;
        }
        DescribeCommandsResponse other = (DescribeCommandsResponse)((Object)obj);
        if (other.commands() == null ^ this.commands() == null) {
            return false;
        }
        return other.commands() == null || other.commands().equals(this.commands());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.commands() != null) {
            sb.append("Commands: ").append(this.commands()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Command> commands;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommandsResponse model) {
            this.setCommands(model.commands);
        }

        public final Collection<Command> getCommands() {
            return this.commands;
        }

        @Override
        public final Builder commands(Collection<Command> commands) {
            this.commands = CommandsCopier.copy(commands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commands(Command ... commands) {
            this.commands(Arrays.asList(commands));
            return this;
        }

        public final void setCommands(Collection<Command> commands) {
            this.commands = CommandsCopier.copy(commands);
        }

        public DescribeCommandsResponse build() {
            return new DescribeCommandsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeCommandsResponse> {
        public Builder commands(Collection<Command> var1);

        public Builder commands(Command ... var1);
    }
}

