/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.Volume;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VolumeMarshaller {
    private static final MarshallingInfo<String> VOLUMEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeId").isBinary(false).build();
    private static final MarshallingInfo<String> EC2VOLUMEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ec2VolumeId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> RAIDARRAYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RaidArrayId").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<Integer> SIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Size").isBinary(false).build();
    private static final MarshallingInfo<String> DEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Device").isBinary(false).build();
    private static final MarshallingInfo<String> MOUNTPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MountPoint").isBinary(false).build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").isBinary(false).build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZone").isBinary(false).build();
    private static final MarshallingInfo<String> VOLUMETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeType").isBinary(false).build();
    private static final MarshallingInfo<Integer> IOPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Iops").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENCRYPTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Encrypted").isBinary(false).build();
    private static final VolumeMarshaller INSTANCE = new VolumeMarshaller();

    private VolumeMarshaller() {
    }

    public static VolumeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Volume volume, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)volume, (String)"volume");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)volume.volumeId(), VOLUMEID_BINDING);
            protocolMarshaller.marshall((Object)volume.ec2VolumeId(), EC2VOLUMEID_BINDING);
            protocolMarshaller.marshall((Object)volume.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)volume.raidArrayId(), RAIDARRAYID_BINDING);
            protocolMarshaller.marshall((Object)volume.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)volume.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)volume.size(), SIZE_BINDING);
            protocolMarshaller.marshall((Object)volume.device(), DEVICE_BINDING);
            protocolMarshaller.marshall((Object)volume.mountPoint(), MOUNTPOINT_BINDING);
            protocolMarshaller.marshall((Object)volume.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)volume.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)volume.volumeType(), VOLUMETYPE_BINDING);
            protocolMarshaller.marshall((Object)volume.iops(), IOPS_BINDING);
            protocolMarshaller.marshall((Object)volume.encrypted(), ENCRYPTED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

