/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.opsworks.model.Stack;
import software.amazon.awssdk.services.opsworks.transform.ChefConfigurationUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.SourceUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.StackConfigurationManagerUnmarshaller;

public class StackUnmarshaller
implements Unmarshaller<Stack, JsonUnmarshallerContext> {
    private static final StackUnmarshaller INSTANCE = new StackUnmarshaller();

    public Stack unmarshall(JsonUnmarshallerContext context) throws Exception {
        Stack.Builder stackBuilder = Stack.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("StackId", targetDepth)) {
                    context.nextToken();
                    stackBuilder.stackId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    stackBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Arn", targetDepth)) {
                    context.nextToken();
                    stackBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Region", targetDepth)) {
                    context.nextToken();
                    stackBuilder.region((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("VpcId", targetDepth)) {
                    context.nextToken();
                    stackBuilder.vpcId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Attributes", targetDepth)) {
                    context.nextToken();
                    stackBuilder.attributesWithStrings(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("ServiceRoleArn", targetDepth)) {
                    context.nextToken();
                    stackBuilder.serviceRoleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DefaultInstanceProfileArn", targetDepth)) {
                    context.nextToken();
                    stackBuilder.defaultInstanceProfileArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DefaultOs", targetDepth)) {
                    context.nextToken();
                    stackBuilder.defaultOs((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("HostnameTheme", targetDepth)) {
                    context.nextToken();
                    stackBuilder.hostnameTheme((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DefaultAvailabilityZone", targetDepth)) {
                    context.nextToken();
                    stackBuilder.defaultAvailabilityZone((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DefaultSubnetId", targetDepth)) {
                    context.nextToken();
                    stackBuilder.defaultSubnetId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CustomJson", targetDepth)) {
                    context.nextToken();
                    stackBuilder.customJson((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ConfigurationManager", targetDepth)) {
                    context.nextToken();
                    stackBuilder.configurationManager(StackConfigurationManagerUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ChefConfiguration", targetDepth)) {
                    context.nextToken();
                    stackBuilder.chefConfiguration(ChefConfigurationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("UseCustomCookbooks", targetDepth)) {
                    context.nextToken();
                    stackBuilder.useCustomCookbooks((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("UseOpsworksSecurityGroups", targetDepth)) {
                    context.nextToken();
                    stackBuilder.useOpsworksSecurityGroups((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("CustomCookbooksSource", targetDepth)) {
                    context.nextToken();
                    stackBuilder.customCookbooksSource(SourceUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DefaultSshKeyName", targetDepth)) {
                    context.nextToken();
                    stackBuilder.defaultSshKeyName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreatedAt", targetDepth)) {
                    context.nextToken();
                    stackBuilder.createdAt((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DefaultRootDeviceType", targetDepth)) {
                    context.nextToken();
                    stackBuilder.defaultRootDeviceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("AgentVersion", targetDepth)) {
                    context.nextToken();
                    stackBuilder.agentVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Stack)stackBuilder.build();
    }

    public static StackUnmarshaller getInstance() {
        return INSTANCE;
    }
}

