/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.RegisterInstanceRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RegisterInstanceRequestModelMarshaller {
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").isBinary(false).build();
    private static final MarshallingInfo<String> HOSTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Hostname").isBinary(false).build();
    private static final MarshallingInfo<String> PUBLICIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PublicIp").isBinary(false).build();
    private static final MarshallingInfo<String> PRIVATEIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivateIp").isBinary(false).build();
    private static final MarshallingInfo<String> RSAPUBLICKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RsaPublicKey").isBinary(false).build();
    private static final MarshallingInfo<String> RSAPUBLICKEYFINGERPRINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RsaPublicKeyFingerprint").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INSTANCEIDENTITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceIdentity").isBinary(false).build();
    private static final RegisterInstanceRequestModelMarshaller INSTANCE = new RegisterInstanceRequestModelMarshaller();

    private RegisterInstanceRequestModelMarshaller() {
    }

    public static RegisterInstanceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RegisterInstanceRequest registerInstanceRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)registerInstanceRequest), (String)"registerInstanceRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)registerInstanceRequest.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall((Object)registerInstanceRequest.hostname(), HOSTNAME_BINDING);
            protocolMarshaller.marshall((Object)registerInstanceRequest.publicIp(), PUBLICIP_BINDING);
            protocolMarshaller.marshall((Object)registerInstanceRequest.privateIp(), PRIVATEIP_BINDING);
            protocolMarshaller.marshall((Object)registerInstanceRequest.rsaPublicKey(), RSAPUBLICKEY_BINDING);
            protocolMarshaller.marshall((Object)registerInstanceRequest.rsaPublicKeyFingerprint(), RSAPUBLICKEYFINGERPRINT_BINDING);
            protocolMarshaller.marshall((Object)registerInstanceRequest.instanceIdentity(), INSTANCEIDENTITY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

