/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.OperatingSystem;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OperatingSystemMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<List> CONFIGURATIONMANAGERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigurationManagers").isBinary(false).build();
    private static final MarshallingInfo<String> REPORTEDNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReportedName").isBinary(false).build();
    private static final MarshallingInfo<String> REPORTEDVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReportedVersion").isBinary(false).build();
    private static final MarshallingInfo<Boolean> SUPPORTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Supported").isBinary(false).build();
    private static final OperatingSystemMarshaller INSTANCE = new OperatingSystemMarshaller();

    private OperatingSystemMarshaller() {
    }

    public static OperatingSystemMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OperatingSystem operatingSystem, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)operatingSystem, (String)"operatingSystem");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)operatingSystem.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)operatingSystem.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)operatingSystem.type(), TYPE_BINDING);
            protocolMarshaller.marshall(operatingSystem.configurationManagers(), CONFIGURATIONMANAGERS_BINDING);
            protocolMarshaller.marshall((Object)operatingSystem.reportedName(), REPORTEDNAME_BINDING);
            protocolMarshaller.marshall((Object)operatingSystem.reportedVersion(), REPORTEDVERSION_BINDING);
            protocolMarshaller.marshall((Object)operatingSystem.supported(), SUPPORTED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

