/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.Deployment;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeploymentMarshaller {
    private static final MarshallingInfo<String> DEPLOYMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeploymentId").isBinary(false).build();
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").isBinary(false).build();
    private static final MarshallingInfo<String> APPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppId").isBinary(false).build();
    private static final MarshallingInfo<String> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").isBinary(false).build();
    private static final MarshallingInfo<String> COMPLETEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletedAt").isBinary(false).build();
    private static final MarshallingInfo<Integer> DURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Duration").isBinary(false).build();
    private static final MarshallingInfo<String> IAMUSERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamUserArn").isBinary(false).build();
    private static final MarshallingInfo<String> COMMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Comment").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> COMMAND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Command").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> CUSTOMJSON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomJson").isBinary(false).build();
    private static final MarshallingInfo<List> INSTANCEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceIds").isBinary(false).build();
    private static final DeploymentMarshaller INSTANCE = new DeploymentMarshaller();

    private DeploymentMarshaller() {
    }

    public static DeploymentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Deployment deployment, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)deployment, (String)"deployment");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deployment.deploymentId(), DEPLOYMENTID_BINDING);
            protocolMarshaller.marshall((Object)deployment.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall((Object)deployment.appId(), APPID_BINDING);
            protocolMarshaller.marshall((Object)deployment.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)deployment.completedAt(), COMPLETEDAT_BINDING);
            protocolMarshaller.marshall((Object)deployment.duration(), DURATION_BINDING);
            protocolMarshaller.marshall((Object)deployment.iamUserArn(), IAMUSERARN_BINDING);
            protocolMarshaller.marshall((Object)deployment.comment(), COMMENT_BINDING);
            protocolMarshaller.marshall((Object)deployment.command(), COMMAND_BINDING);
            protocolMarshaller.marshall((Object)deployment.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)deployment.customJson(), CUSTOMJSON_BINDING);
            protocolMarshaller.marshall(deployment.instanceIds(), INSTANCEIDS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

