/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.CloudWatchLogsConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CloudWatchLogsConfigurationMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final MarshallingInfo<List> LOGSTREAMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogStreams").isBinary(false).build();
    private static final CloudWatchLogsConfigurationMarshaller INSTANCE = new CloudWatchLogsConfigurationMarshaller();

    private CloudWatchLogsConfigurationMarshaller() {
    }

    public static CloudWatchLogsConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CloudWatchLogsConfiguration cloudWatchLogsConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)cloudWatchLogsConfiguration, (String)"cloudWatchLogsConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)cloudWatchLogsConfiguration.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall(cloudWatchLogsConfiguration.logStreams(), LOGSTREAMS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

