/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.StackConfigurationManagerMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackConfigurationManager
implements StructuredPojo,
ToCopyableBuilder<Builder, StackConfigurationManager> {
    private final String name;
    private final String version;

    private StackConfigurationManager(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackConfigurationManager)) {
            return false;
        }
        StackConfigurationManager other = (StackConfigurationManager)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version());
    }

    public String toString() {
        return ToString.builder((String)"StackConfigurationManager").add("Name", (Object)this.name()).add("Version", (Object)this.version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StackConfigurationManagerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(StackConfigurationManager model) {
            this.name(model.name);
            this.version(model.version);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public StackConfigurationManager build() {
            return new StackConfigurationManager(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StackConfigurationManager> {
        public Builder name(String var1);

        public Builder version(String var1);
    }
}

