/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.EnvironmentVariableMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentVariable
implements StructuredPojo,
ToCopyableBuilder<Builder, EnvironmentVariable> {
    private final String key;
    private final String value;
    private final Boolean secure;

    private EnvironmentVariable(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.secure = builder.secure;
    }

    public String key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }

    public Boolean secure() {
        return this.secure;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.secure());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentVariable)) {
            return false;
        }
        EnvironmentVariable other = (EnvironmentVariable)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.secure(), other.secure());
    }

    public String toString() {
        return ToString.builder((String)"EnvironmentVariable").add("Key", (Object)this.key()).add("Value", (Object)this.value()).add("Secure", (Object)this.secure()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Secure": {
                return Optional.ofNullable(clazz.cast(this.secure()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentVariableMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private String value;
        private Boolean secure;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentVariable model) {
            this.key(model.key);
            this.value(model.value);
            this.secure(model.secure);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Boolean getSecure() {
            return this.secure;
        }

        @Override
        public final Builder secure(Boolean secure) {
            this.secure = secure;
            return this;
        }

        public final void setSecure(Boolean secure) {
            this.secure = secure;
        }

        public EnvironmentVariable build() {
            return new EnvironmentVariable(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnvironmentVariable> {
        public Builder key(String var1);

        public Builder value(String var1);

        public Builder secure(Boolean var1);
    }
}

