/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.Layer;
import software.amazon.awssdk.services.opsworks.model.LayersCopier;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLayersResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeLayersResponse> {
    private final List<Layer> layers;

    private DescribeLayersResponse(BuilderImpl builder) {
        super(builder);
        this.layers = builder.layers;
    }

    public List<Layer> layers() {
        return this.layers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.layers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLayersResponse)) {
            return false;
        }
        DescribeLayersResponse other = (DescribeLayersResponse)((Object)obj);
        return Objects.equals(this.layers(), other.layers());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLayersResponse").add("Layers", this.layers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Layers": {
                return Optional.ofNullable(clazz.cast(this.layers()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<Layer> layers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLayersResponse model) {
            super(model);
            this.layers(model.layers);
        }

        public final Collection<Layer.Builder> getLayers() {
            return this.layers != null ? (Collection)this.layers.stream().map(Layer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder layers(Collection<Layer> layers) {
            this.layers = LayersCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Layer ... layers) {
            this.layers(Arrays.asList(layers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Consumer<Layer.Builder> ... layers) {
            this.layers(Stream.of(layers).map(c -> (Layer)((Layer.Builder)Layer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLayers(Collection<Layer.BuilderImpl> layers) {
            this.layers = LayersCopier.copyFromBuilder(layers);
        }

        @Override
        public DescribeLayersResponse build() {
            return new DescribeLayersResponse(this);
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    CopyableBuilder<Builder, DescribeLayersResponse> {
        public Builder layers(Collection<Layer> var1);

        public Builder layers(Layer ... var1);

        public Builder layers(Consumer<Layer.Builder> ... var1);
    }
}

