/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.services.opsworks.model.StackConfigurationManager;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAgentVersionsRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, DescribeAgentVersionsRequest> {
    private final String stackId;
    private final StackConfigurationManager configurationManager;

    private DescribeAgentVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.configurationManager = builder.configurationManager;
    }

    public String stackId() {
        return this.stackId;
    }

    public StackConfigurationManager configurationManager() {
        return this.configurationManager;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationManager());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgentVersionsRequest)) {
            return false;
        }
        DescribeAgentVersionsRequest other = (DescribeAgentVersionsRequest)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.configurationManager(), other.configurationManager());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAgentVersionsRequest").add("StackId", (Object)this.stackId()).add("ConfigurationManager", (Object)this.configurationManager()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "ConfigurationManager": {
                return Optional.ofNullable(clazz.cast(this.configurationManager()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String stackId;
        private StackConfigurationManager configurationManager;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAgentVersionsRequest model) {
            super(model);
            this.stackId(model.stackId);
            this.configurationManager(model.configurationManager);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final StackConfigurationManager.Builder getConfigurationManager() {
            return this.configurationManager != null ? this.configurationManager.toBuilder() : null;
        }

        @Override
        public final Builder configurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        public final void setConfigurationManager(StackConfigurationManager.BuilderImpl configurationManager) {
            this.configurationManager = configurationManager != null ? configurationManager.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAgentVersionsRequest build() {
            return new DescribeAgentVersionsRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    CopyableBuilder<Builder, DescribeAgentVersionsRequest> {
        public Builder stackId(String var1);

        public Builder configurationManager(StackConfigurationManager var1);

        default public Builder configurationManager(Consumer<StackConfigurationManager.Builder> configurationManager) {
            return this.configurationManager((StackConfigurationManager)((StackConfigurationManager.Builder)StackConfigurationManager.builder().applyMutation(configurationManager)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

