/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.BlockDeviceMapping;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BlockDeviceMappingMarshaller {
    private static final MarshallingInfo<String> DEVICENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceName").isBinary(false).build();
    private static final MarshallingInfo<String> NODEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NoDevice").isBinary(false).build();
    private static final MarshallingInfo<String> VIRTUALNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VirtualName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EBS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ebs").isBinary(false).build();
    private static final BlockDeviceMappingMarshaller INSTANCE = new BlockDeviceMappingMarshaller();

    private BlockDeviceMappingMarshaller() {
    }

    public static BlockDeviceMappingMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BlockDeviceMapping blockDeviceMapping, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)blockDeviceMapping, (String)"blockDeviceMapping");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)blockDeviceMapping.deviceName(), DEVICENAME_BINDING);
            protocolMarshaller.marshall((Object)blockDeviceMapping.noDevice(), NODEVICE_BINDING);
            protocolMarshaller.marshall((Object)blockDeviceMapping.virtualName(), VIRTUALNAME_BINDING);
            protocolMarshaller.marshall((Object)blockDeviceMapping.ebs(), EBS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

