/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterRdsDbInstanceRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, RegisterRdsDbInstanceRequest> {
    private final String stackId;
    private final String rdsDbInstanceArn;
    private final String dbUser;
    private final String dbPassword;

    private RegisterRdsDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.rdsDbInstanceArn = builder.rdsDbInstanceArn;
        this.dbUser = builder.dbUser;
        this.dbPassword = builder.dbPassword;
    }

    public String stackId() {
        return this.stackId;
    }

    public String rdsDbInstanceArn() {
        return this.rdsDbInstanceArn;
    }

    public String dbUser() {
        return this.dbUser;
    }

    public String dbPassword() {
        return this.dbPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsDbInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbPassword());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterRdsDbInstanceRequest)) {
            return false;
        }
        RegisterRdsDbInstanceRequest other = (RegisterRdsDbInstanceRequest)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.rdsDbInstanceArn(), other.rdsDbInstanceArn()) && Objects.equals(this.dbUser(), other.dbUser()) && Objects.equals(this.dbPassword(), other.dbPassword());
    }

    public String toString() {
        return ToString.builder((String)"RegisterRdsDbInstanceRequest").add("StackId", (Object)this.stackId()).add("RdsDbInstanceArn", (Object)this.rdsDbInstanceArn()).add("DbUser", (Object)this.dbUser()).add("DbPassword", (Object)this.dbPassword()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "RdsDbInstanceArn": {
                return Optional.of(clazz.cast(this.rdsDbInstanceArn()));
            }
            case "DbUser": {
                return Optional.of(clazz.cast(this.dbUser()));
            }
            case "DbPassword": {
                return Optional.of(clazz.cast(this.dbPassword()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String stackId;
        private String rdsDbInstanceArn;
        private String dbUser;
        private String dbPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterRdsDbInstanceRequest model) {
            super(model);
            this.stackId(model.stackId);
            this.rdsDbInstanceArn(model.rdsDbInstanceArn);
            this.dbUser(model.dbUser);
            this.dbPassword(model.dbPassword);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getRdsDbInstanceArn() {
            return this.rdsDbInstanceArn;
        }

        @Override
        public final Builder rdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
            return this;
        }

        public final void setRdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public final String getDbPassword() {
            return this.dbPassword;
        }

        @Override
        public final Builder dbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
            return this;
        }

        public final void setDbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RegisterRdsDbInstanceRequest build() {
            return new RegisterRdsDbInstanceRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    CopyableBuilder<Builder, RegisterRdsDbInstanceRequest> {
        public Builder stackId(String var1);

        public Builder rdsDbInstanceArn(String var1);

        public Builder dbUser(String var1);

        public Builder dbPassword(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

