/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeUserProfilesRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, DescribeUserProfilesRequest> {
    private final List<String> iamUserArns;

    private DescribeUserProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.iamUserArns = builder.iamUserArns;
    }

    public List<String> iamUserArns() {
        return this.iamUserArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUserArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserProfilesRequest)) {
            return false;
        }
        DescribeUserProfilesRequest other = (DescribeUserProfilesRequest)((Object)obj);
        return Objects.equals(this.iamUserArns(), other.iamUserArns());
    }

    public String toString() {
        return ToString.builder((String)"DescribeUserProfilesRequest").add("IamUserArns", this.iamUserArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IamUserArns": {
                return Optional.of(clazz.cast(this.iamUserArns()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private List<String> iamUserArns;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserProfilesRequest model) {
            super(model);
            this.iamUserArns(model.iamUserArns);
        }

        public final Collection<String> getIamUserArns() {
            return this.iamUserArns;
        }

        @Override
        public final Builder iamUserArns(Collection<String> iamUserArns) {
            this.iamUserArns = StringsCopier.copy(iamUserArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamUserArns(String ... iamUserArns) {
            this.iamUserArns(Arrays.asList(iamUserArns));
            return this;
        }

        public final void setIamUserArns(Collection<String> iamUserArns) {
            this.iamUserArns = StringsCopier.copy(iamUserArns);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeUserProfilesRequest build() {
            return new DescribeUserProfilesRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    CopyableBuilder<Builder, DescribeUserProfilesRequest> {
        public Builder iamUserArns(Collection<String> var1);

        public Builder iamUserArns(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

