/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEcsClustersRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, DescribeEcsClustersRequest> {
    private final List<String> ecsClusterArns;
    private final String stackId;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeEcsClustersRequest(BuilderImpl builder) {
        super(builder);
        this.ecsClusterArns = builder.ecsClusterArns;
        this.stackId = builder.stackId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public List<String> ecsClusterArns() {
        return this.ecsClusterArns;
    }

    public String stackId() {
        return this.stackId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsClusterArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEcsClustersRequest)) {
            return false;
        }
        DescribeEcsClustersRequest other = (DescribeEcsClustersRequest)((Object)obj);
        return Objects.equals(this.ecsClusterArns(), other.ecsClusterArns()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEcsClustersRequest").add("EcsClusterArns", this.ecsClusterArns()).add("StackId", (Object)this.stackId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EcsClusterArns": {
                return Optional.of(clazz.cast(this.ecsClusterArns()));
            }
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private List<String> ecsClusterArns;
        private String stackId;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEcsClustersRequest model) {
            super(model);
            this.ecsClusterArns(model.ecsClusterArns);
            this.stackId(model.stackId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getEcsClusterArns() {
            return this.ecsClusterArns;
        }

        @Override
        public final Builder ecsClusterArns(Collection<String> ecsClusterArns) {
            this.ecsClusterArns = StringsCopier.copy(ecsClusterArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsClusterArns(String ... ecsClusterArns) {
            this.ecsClusterArns(Arrays.asList(ecsClusterArns));
            return this;
        }

        public final void setEcsClusterArns(Collection<String> ecsClusterArns) {
            this.ecsClusterArns = StringsCopier.copy(ecsClusterArns);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeEcsClustersRequest build() {
            return new DescribeEcsClustersRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    CopyableBuilder<Builder, DescribeEcsClustersRequest> {
        public Builder ecsClusterArns(Collection<String> var1);

        public Builder ecsClusterArns(String ... var1);

        public Builder stackId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

