/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.opsworks.model.ChefConfiguration;
import software.amazon.awssdk.services.opsworks.model.RootDeviceType;
import software.amazon.awssdk.services.opsworks.model.Source;
import software.amazon.awssdk.services.opsworks.model.StackAttributesCopier;
import software.amazon.awssdk.services.opsworks.model.StackConfigurationManager;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateStackRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateStackRequest> {
    private final String stackId;
    private final String name;
    private final Map<String, String> attributes;
    private final String serviceRoleArn;
    private final String defaultInstanceProfileArn;
    private final String defaultOs;
    private final String hostnameTheme;
    private final String defaultAvailabilityZone;
    private final String defaultSubnetId;
    private final String customJson;
    private final StackConfigurationManager configurationManager;
    private final ChefConfiguration chefConfiguration;
    private final Boolean useCustomCookbooks;
    private final Source customCookbooksSource;
    private final String defaultSshKeyName;
    private final String defaultRootDeviceType;
    private final Boolean useOpsworksSecurityGroups;
    private final String agentVersion;

    private UpdateStackRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.name = builder.name;
        this.attributes = builder.attributes;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.defaultInstanceProfileArn = builder.defaultInstanceProfileArn;
        this.defaultOs = builder.defaultOs;
        this.hostnameTheme = builder.hostnameTheme;
        this.defaultAvailabilityZone = builder.defaultAvailabilityZone;
        this.defaultSubnetId = builder.defaultSubnetId;
        this.customJson = builder.customJson;
        this.configurationManager = builder.configurationManager;
        this.chefConfiguration = builder.chefConfiguration;
        this.useCustomCookbooks = builder.useCustomCookbooks;
        this.customCookbooksSource = builder.customCookbooksSource;
        this.defaultSshKeyName = builder.defaultSshKeyName;
        this.defaultRootDeviceType = builder.defaultRootDeviceType;
        this.useOpsworksSecurityGroups = builder.useOpsworksSecurityGroups;
        this.agentVersion = builder.agentVersion;
    }

    public String stackId() {
        return this.stackId;
    }

    public String name() {
        return this.name;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public String defaultInstanceProfileArn() {
        return this.defaultInstanceProfileArn;
    }

    public String defaultOs() {
        return this.defaultOs;
    }

    public String hostnameTheme() {
        return this.hostnameTheme;
    }

    public String defaultAvailabilityZone() {
        return this.defaultAvailabilityZone;
    }

    public String defaultSubnetId() {
        return this.defaultSubnetId;
    }

    public String customJson() {
        return this.customJson;
    }

    public StackConfigurationManager configurationManager() {
        return this.configurationManager;
    }

    public ChefConfiguration chefConfiguration() {
        return this.chefConfiguration;
    }

    public Boolean useCustomCookbooks() {
        return this.useCustomCookbooks;
    }

    public Source customCookbooksSource() {
        return this.customCookbooksSource;
    }

    public String defaultSshKeyName() {
        return this.defaultSshKeyName;
    }

    public String defaultRootDeviceType() {
        return this.defaultRootDeviceType;
    }

    public Boolean useOpsworksSecurityGroups() {
        return this.useOpsworksSecurityGroups;
    }

    public String agentVersion() {
        return this.agentVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        hashCode = 31 * hashCode + (this.serviceRoleArn() == null ? 0 : this.serviceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.defaultInstanceProfileArn() == null ? 0 : this.defaultInstanceProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.defaultOs() == null ? 0 : this.defaultOs().hashCode());
        hashCode = 31 * hashCode + (this.hostnameTheme() == null ? 0 : this.hostnameTheme().hashCode());
        hashCode = 31 * hashCode + (this.defaultAvailabilityZone() == null ? 0 : this.defaultAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.defaultSubnetId() == null ? 0 : this.defaultSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.customJson() == null ? 0 : this.customJson().hashCode());
        hashCode = 31 * hashCode + (this.configurationManager() == null ? 0 : this.configurationManager().hashCode());
        hashCode = 31 * hashCode + (this.chefConfiguration() == null ? 0 : this.chefConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.useCustomCookbooks() == null ? 0 : this.useCustomCookbooks().hashCode());
        hashCode = 31 * hashCode + (this.customCookbooksSource() == null ? 0 : this.customCookbooksSource().hashCode());
        hashCode = 31 * hashCode + (this.defaultSshKeyName() == null ? 0 : this.defaultSshKeyName().hashCode());
        hashCode = 31 * hashCode + (this.defaultRootDeviceType() == null ? 0 : this.defaultRootDeviceType().hashCode());
        hashCode = 31 * hashCode + (this.useOpsworksSecurityGroups() == null ? 0 : this.useOpsworksSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.agentVersion() == null ? 0 : this.agentVersion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackRequest)) {
            return false;
        }
        UpdateStackRequest other = (UpdateStackRequest)((Object)obj);
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        if (other.serviceRoleArn() == null ^ this.serviceRoleArn() == null) {
            return false;
        }
        if (other.serviceRoleArn() != null && !other.serviceRoleArn().equals(this.serviceRoleArn())) {
            return false;
        }
        if (other.defaultInstanceProfileArn() == null ^ this.defaultInstanceProfileArn() == null) {
            return false;
        }
        if (other.defaultInstanceProfileArn() != null && !other.defaultInstanceProfileArn().equals(this.defaultInstanceProfileArn())) {
            return false;
        }
        if (other.defaultOs() == null ^ this.defaultOs() == null) {
            return false;
        }
        if (other.defaultOs() != null && !other.defaultOs().equals(this.defaultOs())) {
            return false;
        }
        if (other.hostnameTheme() == null ^ this.hostnameTheme() == null) {
            return false;
        }
        if (other.hostnameTheme() != null && !other.hostnameTheme().equals(this.hostnameTheme())) {
            return false;
        }
        if (other.defaultAvailabilityZone() == null ^ this.defaultAvailabilityZone() == null) {
            return false;
        }
        if (other.defaultAvailabilityZone() != null && !other.defaultAvailabilityZone().equals(this.defaultAvailabilityZone())) {
            return false;
        }
        if (other.defaultSubnetId() == null ^ this.defaultSubnetId() == null) {
            return false;
        }
        if (other.defaultSubnetId() != null && !other.defaultSubnetId().equals(this.defaultSubnetId())) {
            return false;
        }
        if (other.customJson() == null ^ this.customJson() == null) {
            return false;
        }
        if (other.customJson() != null && !other.customJson().equals(this.customJson())) {
            return false;
        }
        if (other.configurationManager() == null ^ this.configurationManager() == null) {
            return false;
        }
        if (other.configurationManager() != null && !other.configurationManager().equals(this.configurationManager())) {
            return false;
        }
        if (other.chefConfiguration() == null ^ this.chefConfiguration() == null) {
            return false;
        }
        if (other.chefConfiguration() != null && !other.chefConfiguration().equals(this.chefConfiguration())) {
            return false;
        }
        if (other.useCustomCookbooks() == null ^ this.useCustomCookbooks() == null) {
            return false;
        }
        if (other.useCustomCookbooks() != null && !other.useCustomCookbooks().equals(this.useCustomCookbooks())) {
            return false;
        }
        if (other.customCookbooksSource() == null ^ this.customCookbooksSource() == null) {
            return false;
        }
        if (other.customCookbooksSource() != null && !other.customCookbooksSource().equals(this.customCookbooksSource())) {
            return false;
        }
        if (other.defaultSshKeyName() == null ^ this.defaultSshKeyName() == null) {
            return false;
        }
        if (other.defaultSshKeyName() != null && !other.defaultSshKeyName().equals(this.defaultSshKeyName())) {
            return false;
        }
        if (other.defaultRootDeviceType() == null ^ this.defaultRootDeviceType() == null) {
            return false;
        }
        if (other.defaultRootDeviceType() != null && !other.defaultRootDeviceType().equals(this.defaultRootDeviceType())) {
            return false;
        }
        if (other.useOpsworksSecurityGroups() == null ^ this.useOpsworksSecurityGroups() == null) {
            return false;
        }
        if (other.useOpsworksSecurityGroups() != null && !other.useOpsworksSecurityGroups().equals(this.useOpsworksSecurityGroups())) {
            return false;
        }
        if (other.agentVersion() == null ^ this.agentVersion() == null) {
            return false;
        }
        return other.agentVersion() == null || other.agentVersion().equals(this.agentVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (this.serviceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(this.serviceRoleArn()).append(",");
        }
        if (this.defaultInstanceProfileArn() != null) {
            sb.append("DefaultInstanceProfileArn: ").append(this.defaultInstanceProfileArn()).append(",");
        }
        if (this.defaultOs() != null) {
            sb.append("DefaultOs: ").append(this.defaultOs()).append(",");
        }
        if (this.hostnameTheme() != null) {
            sb.append("HostnameTheme: ").append(this.hostnameTheme()).append(",");
        }
        if (this.defaultAvailabilityZone() != null) {
            sb.append("DefaultAvailabilityZone: ").append(this.defaultAvailabilityZone()).append(",");
        }
        if (this.defaultSubnetId() != null) {
            sb.append("DefaultSubnetId: ").append(this.defaultSubnetId()).append(",");
        }
        if (this.customJson() != null) {
            sb.append("CustomJson: ").append(this.customJson()).append(",");
        }
        if (this.configurationManager() != null) {
            sb.append("ConfigurationManager: ").append(this.configurationManager()).append(",");
        }
        if (this.chefConfiguration() != null) {
            sb.append("ChefConfiguration: ").append(this.chefConfiguration()).append(",");
        }
        if (this.useCustomCookbooks() != null) {
            sb.append("UseCustomCookbooks: ").append(this.useCustomCookbooks()).append(",");
        }
        if (this.customCookbooksSource() != null) {
            sb.append("CustomCookbooksSource: ").append(this.customCookbooksSource()).append(",");
        }
        if (this.defaultSshKeyName() != null) {
            sb.append("DefaultSshKeyName: ").append(this.defaultSshKeyName()).append(",");
        }
        if (this.defaultRootDeviceType() != null) {
            sb.append("DefaultRootDeviceType: ").append(this.defaultRootDeviceType()).append(",");
        }
        if (this.useOpsworksSecurityGroups() != null) {
            sb.append("UseOpsworksSecurityGroups: ").append(this.useOpsworksSecurityGroups()).append(",");
        }
        if (this.agentVersion() != null) {
            sb.append("AgentVersion: ").append(this.agentVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String name;
        private Map<String, String> attributes = new SdkInternalMap();
        private String serviceRoleArn;
        private String defaultInstanceProfileArn;
        private String defaultOs;
        private String hostnameTheme;
        private String defaultAvailabilityZone;
        private String defaultSubnetId;
        private String customJson;
        private StackConfigurationManager configurationManager;
        private ChefConfiguration chefConfiguration;
        private Boolean useCustomCookbooks;
        private Source customCookbooksSource;
        private String defaultSshKeyName;
        private String defaultRootDeviceType;
        private Boolean useOpsworksSecurityGroups;
        private String agentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStackRequest model) {
            this.setStackId(model.stackId);
            this.setName(model.name);
            this.setAttributes(model.attributes);
            this.setServiceRoleArn(model.serviceRoleArn);
            this.setDefaultInstanceProfileArn(model.defaultInstanceProfileArn);
            this.setDefaultOs(model.defaultOs);
            this.setHostnameTheme(model.hostnameTheme);
            this.setDefaultAvailabilityZone(model.defaultAvailabilityZone);
            this.setDefaultSubnetId(model.defaultSubnetId);
            this.setCustomJson(model.customJson);
            this.setConfigurationManager(model.configurationManager);
            this.setChefConfiguration(model.chefConfiguration);
            this.setUseCustomCookbooks(model.useCustomCookbooks);
            this.setCustomCookbooksSource(model.customCookbooksSource);
            this.setDefaultSshKeyName(model.defaultSshKeyName);
            this.setDefaultRootDeviceType(model.defaultRootDeviceType);
            this.setUseOpsworksSecurityGroups(model.useOpsworksSecurityGroups);
            this.setAgentVersion(model.agentVersion);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = StackAttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = StackAttributesCopier.copy(attributes);
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final String getDefaultInstanceProfileArn() {
            return this.defaultInstanceProfileArn;
        }

        @Override
        public final Builder defaultInstanceProfileArn(String defaultInstanceProfileArn) {
            this.defaultInstanceProfileArn = defaultInstanceProfileArn;
            return this;
        }

        public final void setDefaultInstanceProfileArn(String defaultInstanceProfileArn) {
            this.defaultInstanceProfileArn = defaultInstanceProfileArn;
        }

        public final String getDefaultOs() {
            return this.defaultOs;
        }

        @Override
        public final Builder defaultOs(String defaultOs) {
            this.defaultOs = defaultOs;
            return this;
        }

        public final void setDefaultOs(String defaultOs) {
            this.defaultOs = defaultOs;
        }

        public final String getHostnameTheme() {
            return this.hostnameTheme;
        }

        @Override
        public final Builder hostnameTheme(String hostnameTheme) {
            this.hostnameTheme = hostnameTheme;
            return this;
        }

        public final void setHostnameTheme(String hostnameTheme) {
            this.hostnameTheme = hostnameTheme;
        }

        public final String getDefaultAvailabilityZone() {
            return this.defaultAvailabilityZone;
        }

        @Override
        public final Builder defaultAvailabilityZone(String defaultAvailabilityZone) {
            this.defaultAvailabilityZone = defaultAvailabilityZone;
            return this;
        }

        public final void setDefaultAvailabilityZone(String defaultAvailabilityZone) {
            this.defaultAvailabilityZone = defaultAvailabilityZone;
        }

        public final String getDefaultSubnetId() {
            return this.defaultSubnetId;
        }

        @Override
        public final Builder defaultSubnetId(String defaultSubnetId) {
            this.defaultSubnetId = defaultSubnetId;
            return this;
        }

        public final void setDefaultSubnetId(String defaultSubnetId) {
            this.defaultSubnetId = defaultSubnetId;
        }

        public final String getCustomJson() {
            return this.customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        public final StackConfigurationManager getConfigurationManager() {
            return this.configurationManager;
        }

        @Override
        public final Builder configurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        public final void setConfigurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
        }

        public final ChefConfiguration getChefConfiguration() {
            return this.chefConfiguration;
        }

        @Override
        public final Builder chefConfiguration(ChefConfiguration chefConfiguration) {
            this.chefConfiguration = chefConfiguration;
            return this;
        }

        public final void setChefConfiguration(ChefConfiguration chefConfiguration) {
            this.chefConfiguration = chefConfiguration;
        }

        public final Boolean getUseCustomCookbooks() {
            return this.useCustomCookbooks;
        }

        @Override
        public final Builder useCustomCookbooks(Boolean useCustomCookbooks) {
            this.useCustomCookbooks = useCustomCookbooks;
            return this;
        }

        public final void setUseCustomCookbooks(Boolean useCustomCookbooks) {
            this.useCustomCookbooks = useCustomCookbooks;
        }

        public final Source getCustomCookbooksSource() {
            return this.customCookbooksSource;
        }

        @Override
        public final Builder customCookbooksSource(Source customCookbooksSource) {
            this.customCookbooksSource = customCookbooksSource;
            return this;
        }

        public final void setCustomCookbooksSource(Source customCookbooksSource) {
            this.customCookbooksSource = customCookbooksSource;
        }

        public final String getDefaultSshKeyName() {
            return this.defaultSshKeyName;
        }

        @Override
        public final Builder defaultSshKeyName(String defaultSshKeyName) {
            this.defaultSshKeyName = defaultSshKeyName;
            return this;
        }

        public final void setDefaultSshKeyName(String defaultSshKeyName) {
            this.defaultSshKeyName = defaultSshKeyName;
        }

        public final String getDefaultRootDeviceType() {
            return this.defaultRootDeviceType;
        }

        @Override
        public final Builder defaultRootDeviceType(String defaultRootDeviceType) {
            this.defaultRootDeviceType = defaultRootDeviceType;
            return this;
        }

        @Override
        public final Builder defaultRootDeviceType(RootDeviceType defaultRootDeviceType) {
            this.defaultRootDeviceType(defaultRootDeviceType.toString());
            return this;
        }

        public final void setDefaultRootDeviceType(String defaultRootDeviceType) {
            this.defaultRootDeviceType = defaultRootDeviceType;
        }

        public final void setDefaultRootDeviceType(RootDeviceType defaultRootDeviceType) {
            this.defaultRootDeviceType(defaultRootDeviceType.toString());
        }

        public final Boolean getUseOpsworksSecurityGroups() {
            return this.useOpsworksSecurityGroups;
        }

        @Override
        public final Builder useOpsworksSecurityGroups(Boolean useOpsworksSecurityGroups) {
            this.useOpsworksSecurityGroups = useOpsworksSecurityGroups;
            return this;
        }

        public final void setUseOpsworksSecurityGroups(Boolean useOpsworksSecurityGroups) {
            this.useOpsworksSecurityGroups = useOpsworksSecurityGroups;
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        public UpdateStackRequest build() {
            return new UpdateStackRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateStackRequest> {
        public Builder stackId(String var1);

        public Builder name(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder serviceRoleArn(String var1);

        public Builder defaultInstanceProfileArn(String var1);

        public Builder defaultOs(String var1);

        public Builder hostnameTheme(String var1);

        public Builder defaultAvailabilityZone(String var1);

        public Builder defaultSubnetId(String var1);

        public Builder customJson(String var1);

        public Builder configurationManager(StackConfigurationManager var1);

        public Builder chefConfiguration(ChefConfiguration var1);

        public Builder useCustomCookbooks(Boolean var1);

        public Builder customCookbooksSource(Source var1);

        public Builder defaultSshKeyName(String var1);

        public Builder defaultRootDeviceType(String var1);

        public Builder defaultRootDeviceType(RootDeviceType var1);

        public Builder useOpsworksSecurityGroups(Boolean var1);

        public Builder agentVersion(String var1);
    }
}

