/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeTimeBasedAutoScalingRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeTimeBasedAutoScalingRequest> {
    private final List<String> instanceIds;

    private DescribeTimeBasedAutoScalingRequest(BuilderImpl builder) {
        this.instanceIds = builder.instanceIds;
    }

    public List<String> instanceIds() {
        return this.instanceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceIds() == null ? 0 : this.instanceIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTimeBasedAutoScalingRequest)) {
            return false;
        }
        DescribeTimeBasedAutoScalingRequest other = (DescribeTimeBasedAutoScalingRequest)((Object)obj);
        if (other.instanceIds() == null ^ this.instanceIds() == null) {
            return false;
        }
        return other.instanceIds() == null || other.instanceIds().equals(this.instanceIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceIds() != null) {
            sb.append("InstanceIds: ").append(this.instanceIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> instanceIds = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTimeBasedAutoScalingRequest model) {
            this.setInstanceIds(model.instanceIds);
        }

        public final Collection<String> getInstanceIds() {
            return this.instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = StringsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            if (this.instanceIds == null) {
                this.instanceIds = new SdkInternalList(instanceIds.length);
            }
            for (String e : instanceIds) {
                this.instanceIds.add(e);
            }
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = StringsCopier.copy(instanceIds);
        }

        @SafeVarargs
        public final void setInstanceIds(String ... instanceIds) {
            if (this.instanceIds == null) {
                this.instanceIds = new SdkInternalList(instanceIds.length);
            }
            for (String e : instanceIds) {
                this.instanceIds.add(e);
            }
        }

        public DescribeTimeBasedAutoScalingRequest build() {
            return new DescribeTimeBasedAutoScalingRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeTimeBasedAutoScalingRequest> {
        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);
    }
}

