/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.opsworks.model.ElasticLoadBalancer;
import software.amazon.awssdk.services.opsworks.model.ElasticLoadBalancersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeElasticLoadBalancersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeElasticLoadBalancersResponse> {
    private final List<ElasticLoadBalancer> elasticLoadBalancers;

    private DescribeElasticLoadBalancersResponse(BuilderImpl builder) {
        this.elasticLoadBalancers = builder.elasticLoadBalancers;
    }

    public List<ElasticLoadBalancer> elasticLoadBalancers() {
        return this.elasticLoadBalancers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.elasticLoadBalancers() == null ? 0 : this.elasticLoadBalancers().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticLoadBalancersResponse)) {
            return false;
        }
        DescribeElasticLoadBalancersResponse other = (DescribeElasticLoadBalancersResponse)((Object)obj);
        if (other.elasticLoadBalancers() == null ^ this.elasticLoadBalancers() == null) {
            return false;
        }
        return other.elasticLoadBalancers() == null || other.elasticLoadBalancers().equals(this.elasticLoadBalancers());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.elasticLoadBalancers() != null) {
            sb.append("ElasticLoadBalancers: ").append(this.elasticLoadBalancers()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ElasticLoadBalancer> elasticLoadBalancers = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticLoadBalancersResponse model) {
            this.setElasticLoadBalancers(model.elasticLoadBalancers);
        }

        public final Collection<ElasticLoadBalancer> getElasticLoadBalancers() {
            return this.elasticLoadBalancers;
        }

        @Override
        public final Builder elasticLoadBalancers(Collection<ElasticLoadBalancer> elasticLoadBalancers) {
            this.elasticLoadBalancers = ElasticLoadBalancersCopier.copy(elasticLoadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticLoadBalancers(ElasticLoadBalancer ... elasticLoadBalancers) {
            if (this.elasticLoadBalancers == null) {
                this.elasticLoadBalancers = new SdkInternalList(elasticLoadBalancers.length);
            }
            for (ElasticLoadBalancer e : elasticLoadBalancers) {
                this.elasticLoadBalancers.add(e);
            }
            return this;
        }

        public final void setElasticLoadBalancers(Collection<ElasticLoadBalancer> elasticLoadBalancers) {
            this.elasticLoadBalancers = ElasticLoadBalancersCopier.copy(elasticLoadBalancers);
        }

        @SafeVarargs
        public final void setElasticLoadBalancers(ElasticLoadBalancer ... elasticLoadBalancers) {
            if (this.elasticLoadBalancers == null) {
                this.elasticLoadBalancers = new SdkInternalList(elasticLoadBalancers.length);
            }
            for (ElasticLoadBalancer e : elasticLoadBalancers) {
                this.elasticLoadBalancers.add(e);
            }
        }

        public DescribeElasticLoadBalancersResponse build() {
            return new DescribeElasticLoadBalancersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeElasticLoadBalancersResponse> {
        public Builder elasticLoadBalancers(Collection<ElasticLoadBalancer> var1);

        public Builder elasticLoadBalancers(ElasticLoadBalancer ... var1);
    }
}

