/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDeploymentsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeDeploymentsRequest> {
    private final String stackId;
    private final String appId;
    private final List<String> deploymentIds;

    private DescribeDeploymentsRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.appId = builder.appId;
        this.deploymentIds = builder.deploymentIds;
    }

    public String stackId() {
        return this.stackId;
    }

    public String appId() {
        return this.appId;
    }

    public List<String> deploymentIds() {
        return this.deploymentIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.appId() == null ? 0 : this.appId().hashCode());
        hashCode = 31 * hashCode + (this.deploymentIds() == null ? 0 : this.deploymentIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeploymentsRequest)) {
            return false;
        }
        DescribeDeploymentsRequest other = (DescribeDeploymentsRequest)((Object)obj);
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.appId() == null ^ this.appId() == null) {
            return false;
        }
        if (other.appId() != null && !other.appId().equals(this.appId())) {
            return false;
        }
        if (other.deploymentIds() == null ^ this.deploymentIds() == null) {
            return false;
        }
        return other.deploymentIds() == null || other.deploymentIds().equals(this.deploymentIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.appId() != null) {
            sb.append("AppId: ").append(this.appId()).append(",");
        }
        if (this.deploymentIds() != null) {
            sb.append("DeploymentIds: ").append(this.deploymentIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String appId;
        private List<String> deploymentIds = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeploymentsRequest model) {
            this.setStackId(model.stackId);
            this.setAppId(model.appId);
            this.setDeploymentIds(model.deploymentIds);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getAppId() {
            return this.appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final Collection<String> getDeploymentIds() {
            return this.deploymentIds;
        }

        @Override
        public final Builder deploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = StringsCopier.copy(deploymentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentIds(String ... deploymentIds) {
            if (this.deploymentIds == null) {
                this.deploymentIds = new SdkInternalList(deploymentIds.length);
            }
            for (String e : deploymentIds) {
                this.deploymentIds.add(e);
            }
            return this;
        }

        public final void setDeploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = StringsCopier.copy(deploymentIds);
        }

        @SafeVarargs
        public final void setDeploymentIds(String ... deploymentIds) {
            if (this.deploymentIds == null) {
                this.deploymentIds = new SdkInternalList(deploymentIds.length);
            }
            for (String e : deploymentIds) {
                this.deploymentIds.add(e);
            }
        }

        public DescribeDeploymentsRequest build() {
            return new DescribeDeploymentsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDeploymentsRequest> {
        public Builder stackId(String var1);

        public Builder appId(String var1);

        public Builder deploymentIds(Collection<String> var1);

        public Builder deploymentIds(String ... var1);
    }
}

