/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssignInstanceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AssignInstanceRequest> {
    private final String instanceId;
    private final List<String> layerIds;

    private AssignInstanceRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.layerIds = builder.layerIds;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public List<String> layerIds() {
        return this.layerIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.layerIds() == null ? 0 : this.layerIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignInstanceRequest)) {
            return false;
        }
        AssignInstanceRequest other = (AssignInstanceRequest)((Object)obj);
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.layerIds() == null ^ this.layerIds() == null) {
            return false;
        }
        return other.layerIds() == null || other.layerIds().equals(this.layerIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.layerIds() != null) {
            sb.append("LayerIds: ").append(this.layerIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private List<String> layerIds = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(AssignInstanceRequest model) {
            this.setInstanceId(model.instanceId);
            this.setLayerIds(model.layerIds);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<String> getLayerIds() {
            return this.layerIds;
        }

        @Override
        public final Builder layerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerIds(String ... layerIds) {
            if (this.layerIds == null) {
                this.layerIds = new SdkInternalList(layerIds.length);
            }
            for (String e : layerIds) {
                this.layerIds.add(e);
            }
            return this;
        }

        public final void setLayerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
        }

        @SafeVarargs
        public final void setLayerIds(String ... layerIds) {
            if (this.layerIds == null) {
                this.layerIds = new SdkInternalList(layerIds.length);
            }
            for (String e : layerIds) {
                this.layerIds.add(e);
            }
        }

        public AssignInstanceRequest build() {
            return new AssignInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssignInstanceRequest> {
        public Builder instanceId(String var1);

        public Builder layerIds(Collection<String> var1);

        public Builder layerIds(String ... var1);
    }
}

