/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearchserverless.model.CreateIamIdentityCenterConfigOptions;
import software.amazon.awssdk.services.opensearchserverless.model.IamFederationConfigOptions;
import software.amazon.awssdk.services.opensearchserverless.model.OpenSearchServerlessRequest;
import software.amazon.awssdk.services.opensearchserverless.model.SamlConfigOptions;
import software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSecurityConfigRequest
extends OpenSearchServerlessRequest
implements ToCopyableBuilder<Builder, CreateSecurityConfigRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateSecurityConfigRequest.getter(CreateSecurityConfigRequest::typeAsString)).setter(CreateSecurityConfigRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateSecurityConfigRequest.getter(CreateSecurityConfigRequest::name)).setter(CreateSecurityConfigRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateSecurityConfigRequest.getter(CreateSecurityConfigRequest::description)).setter(CreateSecurityConfigRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<SamlConfigOptions> SAML_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("samlOptions").getter(CreateSecurityConfigRequest.getter(CreateSecurityConfigRequest::samlOptions)).setter(CreateSecurityConfigRequest.setter(Builder::samlOptions)).constructor(SamlConfigOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samlOptions").build()}).build();
    private static final SdkField<CreateIamIdentityCenterConfigOptions> IAM_IDENTITY_CENTER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iamIdentityCenterOptions").getter(CreateSecurityConfigRequest.getter(CreateSecurityConfigRequest::iamIdentityCenterOptions)).setter(CreateSecurityConfigRequest.setter(Builder::iamIdentityCenterOptions)).constructor(CreateIamIdentityCenterConfigOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamIdentityCenterOptions").build()}).build();
    private static final SdkField<IamFederationConfigOptions> IAM_FEDERATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iamFederationOptions").getter(CreateSecurityConfigRequest.getter(CreateSecurityConfigRequest::iamFederationOptions)).setter(CreateSecurityConfigRequest.setter(Builder::iamFederationOptions)).constructor(IamFederationConfigOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamFederationOptions").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateSecurityConfigRequest.getter(CreateSecurityConfigRequest::clientToken)).setter(CreateSecurityConfigRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, NAME_FIELD, DESCRIPTION_FIELD, SAML_OPTIONS_FIELD, IAM_IDENTITY_CENTER_OPTIONS_FIELD, IAM_FEDERATION_OPTIONS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSecurityConfigRequest.memberNameToFieldInitializer();
    private final String type;
    private final String name;
    private final String description;
    private final SamlConfigOptions samlOptions;
    private final CreateIamIdentityCenterConfigOptions iamIdentityCenterOptions;
    private final IamFederationConfigOptions iamFederationOptions;
    private final String clientToken;

    private CreateSecurityConfigRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.name = builder.name;
        this.description = builder.description;
        this.samlOptions = builder.samlOptions;
        this.iamIdentityCenterOptions = builder.iamIdentityCenterOptions;
        this.iamFederationOptions = builder.iamFederationOptions;
        this.clientToken = builder.clientToken;
    }

    public final SecurityConfigType type() {
        return SecurityConfigType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final SamlConfigOptions samlOptions() {
        return this.samlOptions;
    }

    public final CreateIamIdentityCenterConfigOptions iamIdentityCenterOptions() {
        return this.iamIdentityCenterOptions;
    }

    public final IamFederationConfigOptions iamFederationOptions() {
        return this.iamFederationOptions;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.samlOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamIdentityCenterOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamFederationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSecurityConfigRequest)) {
            return false;
        }
        CreateSecurityConfigRequest other = (CreateSecurityConfigRequest)((Object)obj);
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.samlOptions(), other.samlOptions()) && Objects.equals(this.iamIdentityCenterOptions(), other.iamIdentityCenterOptions()) && Objects.equals(this.iamFederationOptions(), other.iamFederationOptions()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSecurityConfigRequest").add("Type", (Object)this.typeAsString()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("SamlOptions", (Object)this.samlOptions()).add("IamIdentityCenterOptions", (Object)this.iamIdentityCenterOptions()).add("IamFederationOptions", (Object)this.iamFederationOptions()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "samlOptions": {
                return Optional.ofNullable(clazz.cast(this.samlOptions()));
            }
            case "iamIdentityCenterOptions": {
                return Optional.ofNullable(clazz.cast(this.iamIdentityCenterOptions()));
            }
            case "iamFederationOptions": {
                return Optional.ofNullable(clazz.cast(this.iamFederationOptions()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("samlOptions", SAML_OPTIONS_FIELD);
        map.put("iamIdentityCenterOptions", IAM_IDENTITY_CENTER_OPTIONS_FIELD);
        map.put("iamFederationOptions", IAM_FEDERATION_OPTIONS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSecurityConfigRequest, T> g) {
        return obj -> g.apply((CreateSecurityConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchServerlessRequest.BuilderImpl
    implements Builder {
        private String type;
        private String name;
        private String description;
        private SamlConfigOptions samlOptions;
        private CreateIamIdentityCenterConfigOptions iamIdentityCenterOptions;
        private IamFederationConfigOptions iamFederationOptions;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSecurityConfigRequest model) {
            super(model);
            this.type(model.type);
            this.name(model.name);
            this.description(model.description);
            this.samlOptions(model.samlOptions);
            this.iamIdentityCenterOptions(model.iamIdentityCenterOptions);
            this.iamFederationOptions(model.iamFederationOptions);
            this.clientToken(model.clientToken);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SecurityConfigType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SamlConfigOptions.Builder getSamlOptions() {
            return this.samlOptions != null ? this.samlOptions.toBuilder() : null;
        }

        public final void setSamlOptions(SamlConfigOptions.BuilderImpl samlOptions) {
            this.samlOptions = samlOptions != null ? samlOptions.build() : null;
        }

        @Override
        public final Builder samlOptions(SamlConfigOptions samlOptions) {
            this.samlOptions = samlOptions;
            return this;
        }

        public final CreateIamIdentityCenterConfigOptions.Builder getIamIdentityCenterOptions() {
            return this.iamIdentityCenterOptions != null ? this.iamIdentityCenterOptions.toBuilder() : null;
        }

        public final void setIamIdentityCenterOptions(CreateIamIdentityCenterConfigOptions.BuilderImpl iamIdentityCenterOptions) {
            this.iamIdentityCenterOptions = iamIdentityCenterOptions != null ? iamIdentityCenterOptions.build() : null;
        }

        @Override
        public final Builder iamIdentityCenterOptions(CreateIamIdentityCenterConfigOptions iamIdentityCenterOptions) {
            this.iamIdentityCenterOptions = iamIdentityCenterOptions;
            return this;
        }

        public final IamFederationConfigOptions.Builder getIamFederationOptions() {
            return this.iamFederationOptions != null ? this.iamFederationOptions.toBuilder() : null;
        }

        public final void setIamFederationOptions(IamFederationConfigOptions.BuilderImpl iamFederationOptions) {
            this.iamFederationOptions = iamFederationOptions != null ? iamFederationOptions.build() : null;
        }

        @Override
        public final Builder iamFederationOptions(IamFederationConfigOptions iamFederationOptions) {
            this.iamFederationOptions = iamFederationOptions;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSecurityConfigRequest build() {
            return new CreateSecurityConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OpenSearchServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSecurityConfigRequest> {
        public Builder type(String var1);

        public Builder type(SecurityConfigType var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder samlOptions(SamlConfigOptions var1);

        default public Builder samlOptions(Consumer<SamlConfigOptions.Builder> samlOptions) {
            return this.samlOptions((SamlConfigOptions)((SamlConfigOptions.Builder)SamlConfigOptions.builder().applyMutation(samlOptions)).build());
        }

        public Builder iamIdentityCenterOptions(CreateIamIdentityCenterConfigOptions var1);

        default public Builder iamIdentityCenterOptions(Consumer<CreateIamIdentityCenterConfigOptions.Builder> iamIdentityCenterOptions) {
            return this.iamIdentityCenterOptions((CreateIamIdentityCenterConfigOptions)((CreateIamIdentityCenterConfigOptions.Builder)CreateIamIdentityCenterConfigOptions.builder().applyMutation(iamIdentityCenterOptions)).build());
        }

        public Builder iamFederationOptions(IamFederationConfigOptions var1);

        default public Builder iamFederationOptions(Consumer<IamFederationConfigOptions.Builder> iamFederationOptions) {
            return this.iamFederationOptions((IamFederationConfigOptions)((IamFederationConfigOptions.Builder)IamFederationConfigOptions.builder().applyMutation(iamFederationOptions)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

